/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.dfa;

import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.dfa.LocationMarker;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.AllocationPhase;
import org.graalvm.compiler.lir.util.IndexedValueMap;
import org.graalvm.compiler.lir.util.ValueSet;

public final class MarkBasePointersPhase
extends AllocationPhase {
    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, AllocationPhase.AllocationContext context) {
        new Marker(lirGenRes.getLIR(), null).build();
    }

    private static final class Marker
    extends LocationMarker<BasePointersSet> {
        private Marker(LIR lir, FrameMap frameMap) {
            super(lir, frameMap);
        }

        @Override
        protected BasePointersSet newLiveValueSet() {
            return new BasePointersSet();
        }

        @Override
        protected boolean shouldProcessValue(Value operand) {
            ValueKind kind = operand.getValueKind();
            if (kind instanceof LIRKind) {
                return ((LIRKind)kind).isDerivedReference();
            }
            return false;
        }

        @Override
        protected void processState(LIRInstruction op, LIRFrameState info, BasePointersSet values) {
            info.setLiveBasePointers(new IndexedValueMap(values.variables));
        }

        private final class BasePointersSet
        extends ValueSet<BasePointersSet> {
            private final IndexedValueMap variables;

            BasePointersSet() {
                this.variables = new IndexedValueMap();
            }

            private BasePointersSet(BasePointersSet s) {
                this.variables = new IndexedValueMap(s.variables);
            }

            @Override
            public BasePointersSet copy() {
                return new BasePointersSet(this);
            }

            @Override
            public void put(Value v) {
                Variable base = (Variable)((LIRKind)v.getValueKind(LIRKind.class)).getDerivedReferenceBase();
                assert (!((LIRKind)base.getValueKind(LIRKind.class)).isValue());
                this.variables.put(base.index, (Value)base);
            }

            @Override
            public void putAll(BasePointersSet v) {
                this.variables.putAll(v.variables);
            }

            @Override
            public void remove(Value v) {
                Variable base = (Variable)((LIRKind)v.getValueKind(LIRKind.class)).getDerivedReferenceBase();
                assert (!((LIRKind)base.getValueKind(LIRKind.class)).isValue());
                this.variables.put(base.index, null);
            }

            public boolean equals(Object obj) {
                if (obj instanceof BasePointersSet) {
                    BasePointersSet other = (BasePointersSet)obj;
                    return this.variables.equals(other.variables);
                }
                return false;
            }

            public int hashCode() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

