/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.gen;

import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.lir.LIRInsertionBuffer;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

public class PhiResolver {
    private final LIRGeneratorTool gen;
    private final LIRGeneratorTool.MoveFactory moveFactory;
    private final LIRInsertionBuffer buffer;
    private final int insertBefore;
    private PhiResolverNode loop;
    private Value temp;
    private final ArrayList<PhiResolverNode> variableOperands = new ArrayList(3);
    private final ArrayList<PhiResolverNode> otherOperands = new ArrayList(3);
    private final EconomicMap<Value, PhiResolverNode> operandToNodeMap = EconomicMap.create((Equivalence)Equivalence.DEFAULT);

    public static PhiResolver create(LIRGeneratorTool gen) {
        AbstractBlockBase<?> block = gen.getCurrentBlock();
        assert (block != null);
        ArrayList<LIRInstruction> instructions = gen.getResult().getLIR().getLIRforBlock(block);
        return new PhiResolver(gen, new LIRInsertionBuffer(), instructions, instructions.size());
    }

    public static PhiResolver create(LIRGeneratorTool gen, LIRInsertionBuffer buffer, List<LIRInstruction> instructions, int insertBefore) {
        return new PhiResolver(gen, buffer, instructions, insertBefore);
    }

    protected PhiResolver(LIRGeneratorTool gen, LIRInsertionBuffer buffer, List<LIRInstruction> instructions, int insertBefore) {
        this.gen = gen;
        this.moveFactory = gen.getSpillMoveFactory();
        this.temp = Value.ILLEGAL;
        this.buffer = buffer;
        this.buffer.init(instructions);
        this.insertBefore = insertBefore;
    }

    public void dispose() {
        PhiResolverNode node;
        int i;
        for (i = this.variableOperands.size() - 1; i >= 0; --i) {
            node = this.variableOperands.get(i);
            if (node.visited) continue;
            this.loop = null;
            this.move(node, null);
            node.startNode = true;
            assert (ValueUtil.isIllegal((Value)this.temp)) : "moveTempTo() call missing";
        }
        for (i = this.otherOperands.size() - 1; i >= 0; --i) {
            node = this.otherOperands.get(i);
            for (int j = node.destinations.size() - 1; j >= 0; --j) {
                this.emitMove(node.destinations.get((int)j).operand, node.operand);
            }
        }
        this.buffer.finish();
    }

    public void move(Value dest, Value src) {
        assert (LIRValueUtil.isVariable(dest)) : "destination must be virtual";
        assert (ValueUtil.isLegal((Value)src)) : "source for phi move is illegal";
        assert (ValueUtil.isLegal((Value)dest)) : "destination for phi move is illegal";
        PhiResolverNode srcNode = this.sourceNode(src);
        PhiResolverNode destNode = this.destinationNode(dest);
        srcNode.destinations.add(destNode);
    }

    private PhiResolverNode createNode(Value operand, boolean source) {
        PhiResolverNode node;
        if (LIRValueUtil.isVariable(operand)) {
            node = (PhiResolverNode)this.operandToNodeMap.get((Object)operand);
            assert (node == null || node.operand.equals((Object)operand));
            if (node == null) {
                node = new PhiResolverNode(operand);
                this.operandToNodeMap.put((Object)operand, (Object)node);
            }
            if (source && !this.variableOperands.contains(node)) {
                this.variableOperands.add(node);
            }
        } else {
            assert (source);
            node = new PhiResolverNode(operand);
            this.otherOperands.add(node);
        }
        return node;
    }

    private PhiResolverNode destinationNode(Value opr) {
        return this.createNode(opr, false);
    }

    private void emitMove(Value dest, Value src) {
        assert (ValueUtil.isLegal((Value)src));
        assert (ValueUtil.isLegal((Value)dest));
        LIRInstruction move = this.moveFactory.createMove((AllocatableValue)dest, src);
        this.buffer.append(this.insertBefore, move);
    }

    private void move(PhiResolverNode dest, PhiResolverNode src) {
        if (!dest.visited) {
            dest.visited = true;
            for (int i = dest.destinations.size() - 1; i >= 0; --i) {
                this.move(dest.destinations.get(i), dest);
            }
        } else if (!dest.startNode) {
            assert (this.loop == null) : "only one loop valid!";
            this.loop = dest;
            this.moveToTemp(src.operand);
            return;
        }
        if (!dest.assigned) {
            if (this.loop == dest) {
                this.moveTempTo(dest.operand);
                dest.assigned = true;
            } else if (src != null) {
                this.emitMove(dest.operand, src.operand);
                dest.assigned = true;
            }
        }
    }

    private void moveTempTo(Value dest) {
        assert (ValueUtil.isLegal((Value)this.temp));
        this.emitMove(dest, this.temp);
        this.temp = Value.ILLEGAL;
    }

    private void moveToTemp(Value src) {
        assert (ValueUtil.isIllegal((Value)this.temp));
        this.temp = this.gen.newVariable(src.getValueKind());
        this.emitMove(this.temp, src);
    }

    private PhiResolverNode sourceNode(Value opr) {
        return this.createNode(opr, true);
    }

    static class PhiResolverNode {
        final Value operand;
        final ArrayList<PhiResolverNode> destinations;
        boolean assigned;
        boolean visited;
        boolean startNode;

        PhiResolverNode(Value operand) {
            this.operand = operand;
            this.destinations = new ArrayList(4);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(this.operand.toString());
            if (!this.destinations.isEmpty()) {
                buf.append(" ->");
                for (PhiResolverNode node : this.destinations) {
                    buf.append(' ').append(node.operand);
                }
            }
            return buf.toString();
        }
    }
}

