/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.hashing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGenerator;

public abstract class HashFunction {
    private static List<HashFunction> instances = new ArrayList<HashFunction>();
    private static int[] mersennePrimes = new int[]{3, 7, 31, 127, 8191, 131071, 524287, Integer.MAX_VALUE};

    public abstract int apply(int var1, int var2);

    public abstract Value gen(Value var1, Value var2, ArithmeticLIRGenerator var3);

    public abstract int effort();

    public static final List<HashFunction> instances() {
        return Collections.unmodifiableList(instances);
    }

    private static void add(final String toString, final int effort, final BiFunction<Integer, Integer, Integer> f, final Function<ArithmeticLIRGenerator, BiFunction<Value, Value, Value>> gen) {
        instances.add(new HashFunction(){

            @Override
            public int apply(int value, int min) {
                return (Integer)f.apply(value, min);
            }

            @Override
            public int effort() {
                return effort;
            }

            public String toString() {
                return toString;
            }

            @Override
            public Value gen(Value val, Value min, ArithmeticLIRGenerator t) {
                return (Value)((BiFunction)gen.apply(t)).apply(t.emitNarrow(val, 32), t.emitNarrow(min, 32));
            }
        });
    }

    private static void addWithPrimes(String toString, int effort, Function<Integer, BiFunction<Integer, Integer, Integer>> f, BiFunction<ArithmeticLIRGenerator, Value, BiFunction<Value, Value, Value>> gen) {
        for (int p : mersennePrimes) {
            HashFunction.add(toString, effort, f.apply(p), g -> (BiFunction)gen.apply((ArithmeticLIRGenerator)g, g.getLIRGen().emitJavaConstant((JavaConstant)JavaConstant.forInt((int)p))));
        }
    }

    static {
        HashFunction.add("val", 0, (val, min) -> val, gen -> (val, min) -> val);
        HashFunction.add("val - min", 1, (val, min) -> val - min, gen -> (val, min) -> gen.emitSub((Value)val, (Value)min, false));
        HashFunction.add("val >> min", 1, (val, min) -> val >> min, gen -> (val, min) -> gen.emitShr((Value)val, (Value)min));
        HashFunction.add("val >> (val & min)", 2, (val, min) -> val >> (val & min), gen -> (val, min) -> gen.emitShr((Value)val, gen.emitAnd((Value)val, (Value)min)));
        HashFunction.add("(val >> min) ^ val", 2, (val, min) -> val >> min ^ val, gen -> (val, min) -> gen.emitXor(gen.emitShr((Value)val, (Value)min), (Value)val));
        HashFunction.add("(val >> min) * val", 3, (val, min) -> (val >> min) * val, gen -> (val, min) -> gen.emitMul(gen.emitShr((Value)val, (Value)min), (Value)val, false));
        HashFunction.addWithPrimes("(val * prime) >> min", 3, prime -> (val, min) -> val * prime >> min, (gen, prime) -> (val, min) -> gen.emitShr(gen.emitMul((Value)val, (Value)prime, false), (Value)min));
        HashFunction.addWithPrimes("rotateRight(val, prime)", 3, prime -> (val, min) -> Integer.rotateRight(val, prime), (gen, prime) -> (val, min) -> gen.emitRor((Value)val, (Value)prime));
        HashFunction.addWithPrimes("rotateRight(val, prime) + val", 4, prime -> (val, min) -> Integer.rotateRight(val, prime) + val, (gen, prime) -> (val, min) -> gen.emitAdd(gen.emitRor((Value)val, (Value)prime), (Value)val, false));
        HashFunction.addWithPrimes("rotateRight(val, prime) ^ val", 4, prime -> (val, min) -> Integer.rotateRight(val, prime) ^ val, (gen, prime) -> (val, min) -> gen.emitXor(gen.emitRor((Value)val, (Value)prime), (Value)val));
    }
}

