/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.hashing;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.TreeSet;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGenerator;
import org.graalvm.compiler.lir.hashing.HashFunction;

public final class Hasher {
    private final HashFunction function;
    private final int cardinality;
    private final int min;

    public static Optional<Hasher> forKeys(JavaConstant[] keys, double minDensity) {
        assert (Hasher.checkKeyKind(keys));
        if (keys.length <= 2) {
            return Optional.empty();
        }
        int maxCardinality = (int)Math.round((double)keys.length / minDensity);
        assert (Hasher.checkIfSorted(keys));
        TreeSet<Hasher> candidates = new TreeSet<Hasher>(new Comparator<Hasher>(){

            @Override
            public int compare(Hasher o1, Hasher o2) {
                int d = o1.cardinality - o2.cardinality;
                if (d != 0) {
                    return d;
                }
                return o1.effort() - o2.effort();
            }
        });
        int min = keys[0].asInt();
        block0: for (HashFunction f : HashFunction.instances()) {
            for (int cardinality = keys.length; cardinality < maxCardinality; ++cardinality) {
                if (!Hasher.isValid(keys, min, f, cardinality)) continue;
                candidates.add(new Hasher(f, cardinality, min));
                continue block0;
            }
        }
        if (candidates.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(candidates.first());
    }

    private static boolean checkKeyKind(JavaConstant[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].getJavaKind() != JavaKind.Int) {
                throw new AssertionError((Object)String.format("Key at index %d is not an int: %s", i, keys[i]));
            }
        }
        return true;
    }

    private static boolean checkIfSorted(JavaConstant[] keys) {
        for (int i = 1; i < keys.length; ++i) {
            if (keys[i - 1].asInt() >= keys[i].asInt()) {
                throw new AssertionError((Object)"Keys array is not sorted");
            }
        }
        return true;
    }

    private static boolean isValid(JavaConstant[] keys, int min, HashFunction function, int cardinality) {
        HashSet<Integer> seen = new HashSet<Integer>(keys.length);
        for (JavaConstant key : keys) {
            int hash = function.apply(key.asInt(), min) & cardinality - 1;
            if (seen.add(hash)) continue;
            return false;
        }
        return true;
    }

    private Hasher(HashFunction function, int cardinality, int min) {
        this.function = function;
        this.cardinality = cardinality;
        this.min = min;
    }

    public int hash(int value) {
        return this.function.apply(value, this.min) & this.cardinality - 1;
    }

    public Value hash(Value value, ArithmeticLIRGenerator gen) {
        Value h = this.function.gen(value, gen.getLIRGen().emitJavaConstant((JavaConstant)JavaConstant.forInt((int)this.min)), gen);
        return gen.emitAnd(h, gen.getLIRGen().emitJavaConstant((JavaConstant)JavaConstant.forInt((int)(this.cardinality - 1))));
    }

    public int effort() {
        return this.function.effort() + 1;
    }

    public int cardinality() {
        return this.cardinality;
    }

    public HashFunction function() {
        return this.function;
    }

    public String toString() {
        return "Hasher[function=" + this.function + ", effort=" + this.effort() + ", cardinality=" + this.cardinality + "]";
    }
}

