/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.phases;

import org.graalvm.compiler.lir.phases.AllocationPhase;
import org.graalvm.compiler.lir.phases.LIRPhaseSuite;
import org.graalvm.compiler.lir.phases.PostAllocationOptimizationPhase;
import org.graalvm.compiler.lir.phases.PreAllocationOptimizationPhase;

public class LIRSuites {
    private final LIRPhaseSuite<PreAllocationOptimizationPhase.PreAllocationOptimizationContext> preAllocOptStage;
    private final LIRPhaseSuite<AllocationPhase.AllocationContext> allocStage;
    private final LIRPhaseSuite<PostAllocationOptimizationPhase.PostAllocationOptimizationContext> postAllocStage;
    private boolean immutable;

    public LIRSuites(LIRPhaseSuite<PreAllocationOptimizationPhase.PreAllocationOptimizationContext> preAllocOptStage, LIRPhaseSuite<AllocationPhase.AllocationContext> allocStage, LIRPhaseSuite<PostAllocationOptimizationPhase.PostAllocationOptimizationContext> postAllocStage) {
        this.preAllocOptStage = preAllocOptStage;
        this.allocStage = allocStage;
        this.postAllocStage = postAllocStage;
    }

    public LIRSuites(LIRSuites other) {
        this(other.getPreAllocationOptimizationStage().copy(), other.getAllocationStage().copy(), other.getPostAllocationOptimizationStage().copy());
    }

    public LIRPhaseSuite<PreAllocationOptimizationPhase.PreAllocationOptimizationContext> getPreAllocationOptimizationStage() {
        return this.preAllocOptStage;
    }

    public LIRPhaseSuite<AllocationPhase.AllocationContext> getAllocationStage() {
        return this.allocStage;
    }

    public LIRPhaseSuite<PostAllocationOptimizationPhase.PostAllocationOptimizationContext> getPostAllocationOptimizationStage() {
        return this.postAllocStage;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public synchronized void setImmutable() {
        if (!this.immutable) {
            this.preAllocOptStage.setImmutable();
            this.allocStage.setImmutable();
            this.postAllocStage.setImmutable();
            this.immutable = true;
        }
    }

    public LIRSuites copy() {
        return new LIRSuites(this.preAllocOptStage.copy(), this.allocStage.copy(), this.postAllocStage.copy());
    }
}

