/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.sparc;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.sparc.SPARCKind;
import org.graalvm.compiler.asm.sparc.SPARCAddress;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.lir.sparc.SPARCDelayedControlTransfer;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstruction;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;
import org.graalvm.compiler.lir.sparc.SPARCMove;
import org.graalvm.compiler.lir.sparc.SPARCTailDelayedLIRInstruction;

@Opcode(value="BSWAP")
public final class SPARCByteSwapOp
extends SPARCLIRInstruction
implements SPARCTailDelayedLIRInstruction {
    public static final LIRInstructionClass<SPARCByteSwapOp> TYPE = LIRInstructionClass.create(SPARCByteSwapOp.class);
    public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(3);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
    protected AllocatableValue result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue input;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue tempIndex;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.UNINITIALIZED})
    protected AllocatableValue tmpSlot;

    public SPARCByteSwapOp(LIRGeneratorTool tool, AllocatableValue result, AllocatableValue input) {
        super(TYPE, SIZE);
        this.result = result;
        this.input = input;
        this.tmpSlot = tool.getResult().getFrameMapBuilder().allocateSpillSlot(LIRKind.value((PlatformKind)SPARCKind.XWORD));
        this.tempIndex = tool.newVariable(LIRKind.value((PlatformKind)SPARCKind.XWORD));
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        SPARCAddress addr = (SPARCAddress)crb.asAddress((Value)this.tmpSlot);
        SPARCMove.emitStore((Value)this.input, addr, this.result.getPlatformKind(), SPARCDelayedControlTransfer.DUMMY, null, crb, masm);
        if (addr.getIndex().equals((Object)Register.None)) {
            Register tempReg = ValueUtil.asRegister((Value)this.tempIndex, (PlatformKind)SPARCKind.XWORD);
            masm.setx(addr.getDisplacement(), tempReg, false);
            addr = new SPARCAddress(addr.getBase(), tempReg);
        }
        this.getDelayedControlTransfer().emitControlTransfer(crb, masm);
        switch ((SPARCKind)this.input.getPlatformKind()) {
            case WORD: {
                masm.lduwa(addr.getBase(), addr.getIndex(), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.WORD), SPARCAssembler.Asi.ASI_PRIMARY_LITTLE);
                break;
            }
            case XWORD: {
                masm.ldxa(addr.getBase(), addr.getIndex(), ValueUtil.asRegister((Value)this.result, (PlatformKind)SPARCKind.XWORD), SPARCAssembler.Asi.ASI_PRIMARY_LITTLE);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
    }
}

