/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.sparc;

import java.util.EnumSet;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.sparc.SPARCAddress;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.lir.CompositeValue;
import org.graalvm.compiler.lir.InstructionValueConsumer;
import org.graalvm.compiler.lir.InstructionValueProcedure;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.sparc.SPARCAddressValue;

public final class SPARCImmediateAddressValue
extends SPARCAddressValue {
    @CompositeValue.Component(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue base;
    protected final int displacement;
    private static final EnumSet<LIRInstruction.OperandFlag> flags = EnumSet.of(LIRInstruction.OperandFlag.REG);

    public SPARCImmediateAddressValue(ValueKind<?> kind, AllocatableValue base, int displacement) {
        super(kind);
        assert (SPARCAssembler.isSimm13(displacement));
        this.base = base;
        this.displacement = displacement;
    }

    @Override
    public CompositeValue forEachComponent(LIRInstruction inst, LIRInstruction.OperandMode mode, InstructionValueProcedure proc) {
        AllocatableValue newBase = (AllocatableValue)proc.doValue(inst, (Value)this.base, mode, flags);
        if (!this.base.identityEquals((Value)newBase)) {
            return new SPARCImmediateAddressValue(this.getValueKind(), newBase, this.displacement);
        }
        return this;
    }

    @Override
    protected void visitEachComponent(LIRInstruction inst, LIRInstruction.OperandMode mode, InstructionValueConsumer proc) {
        proc.visitValue(inst, (Value)this.base, mode, flags);
    }

    @Override
    public SPARCAddress toAddress() {
        return new SPARCAddress(ValueUtil.asRegister((Value)this.base), this.displacement);
    }

    @Override
    public boolean isValidImplicitNullCheckFor(Value value, int implicitNullCheckLimit) {
        return value.equals((Object)this.base) && this.displacement >= 0 && this.displacement < implicitNullCheckLimit;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("[");
        String sep = "";
        if (ValueUtil.isLegal((Value)this.base)) {
            s.append(this.base);
            sep = " + ";
        }
        if (this.displacement < 0) {
            s.append(" - ").append(-this.displacement);
        } else if (this.displacement > 0) {
            s.append(sep).append(this.displacement);
        }
        s.append("]");
        return s.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SPARCImmediateAddressValue) {
            SPARCImmediateAddressValue addr = (SPARCImmediateAddressValue)((Object)obj);
            return this.getValueKind().equals(addr.getValueKind()) && this.displacement == addr.displacement && this.base.equals((Object)addr.base);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.base.hashCode() ^ this.displacement << 4 ^ this.getValueKind().hashCode();
    }
}

