/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.sparc;

import java.util.EnumSet;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.sparc.SPARCAddress;
import org.graalvm.compiler.lir.CompositeValue;
import org.graalvm.compiler.lir.InstructionValueConsumer;
import org.graalvm.compiler.lir.InstructionValueProcedure;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.sparc.SPARCAddressValue;

public final class SPARCIndexedAddressValue
extends SPARCAddressValue {
    @CompositeValue.Component(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue base;
    @CompositeValue.Component(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue index;
    private static final EnumSet<LIRInstruction.OperandFlag> flags = EnumSet.of(LIRInstruction.OperandFlag.REG);

    public SPARCIndexedAddressValue(ValueKind<?> kind, AllocatableValue base, AllocatableValue index) {
        super(kind);
        this.base = base;
        this.index = index;
    }

    @Override
    public CompositeValue forEachComponent(LIRInstruction inst, LIRInstruction.OperandMode mode, InstructionValueProcedure proc) {
        AllocatableValue newBase = (AllocatableValue)proc.doValue(inst, (Value)this.base, mode, flags);
        AllocatableValue newIndex = (AllocatableValue)proc.doValue(inst, (Value)this.index, mode, flags);
        if (!this.base.identityEquals((Value)newBase) || !this.index.identityEquals((Value)newIndex)) {
            return new SPARCIndexedAddressValue(this.getValueKind(), newBase, newIndex);
        }
        return this;
    }

    @Override
    protected void visitEachComponent(LIRInstruction inst, LIRInstruction.OperandMode mode, InstructionValueConsumer proc) {
        proc.visitValue(inst, (Value)this.base, mode, flags);
        proc.visitValue(inst, (Value)this.index, mode, flags);
    }

    @Override
    public SPARCAddress toAddress() {
        return new SPARCAddress(ValueUtil.asRegister((Value)this.base), ValueUtil.asRegister((Value)this.index));
    }

    @Override
    public boolean isValidImplicitNullCheckFor(Value value, int implicitNullCheckLimit) {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("[");
        String sep = "";
        if (ValueUtil.isLegal((Value)this.base)) {
            s.append(this.base);
            sep = " + ";
        }
        if (ValueUtil.isLegal((Value)this.index)) {
            s.append(sep).append(this.index);
        }
        s.append("]");
        return s.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SPARCIndexedAddressValue) {
            SPARCIndexedAddressValue addr = (SPARCIndexedAddressValue)((Object)obj);
            return this.getValueKind().equals(addr.getValueKind()) && this.base.equals((Object)addr.base) && this.index.equals((Object)addr.index);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.base.hashCode() ^ this.index.hashCode() ^ this.getValueKind().hashCode();
    }
}

