/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.sparc;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstruction;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;

public class SPARCLoadConstantTableBaseOp
extends SPARCLIRInstruction {
    public static final LIRInstructionClass<SPARCLoadConstantTableBaseOp> TYPE = LIRInstructionClass.create(SPARCLoadConstantTableBaseOp.class);
    public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(9);
    private final StandardOp.NoOp placeHolder;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    private AllocatableValue base;

    public SPARCLoadConstantTableBaseOp(Variable base, StandardOp.NoOp placeHolder) {
        super(TYPE, SIZE);
        this.base = base;
        this.placeHolder = placeHolder;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        Register baseRegister = ValueUtil.asRegister((Value)this.base);
        int beforePosition = masm.position();
        masm.rdpc(baseRegister);
        masm.add(baseRegister, (int)SPARCAssembler.minSimm(13L), baseRegister);
        masm.sub(baseRegister, beforePosition, baseRegister);
    }

    public AllocatableValue getResult() {
        return this.base;
    }

    public void setAlive(LIR lir, boolean alive) {
        if (alive) {
            this.placeHolder.replace(lir, this);
        } else {
            this.placeHolder.remove(lir);
        }
    }
}

