/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.sparc;

import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import jdk.vm.ci.sparc.SPARC;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.asm.sparc.SPARCMacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstruction;
import org.graalvm.compiler.lir.sparc.SPARCLIRInstructionMixin;
import org.graalvm.compiler.lir.sparc.SPARCTailDelayedLIRInstruction;

public final class SPARCOP3Op
extends SPARCLIRInstruction
implements SPARCTailDelayedLIRInstruction {
    public static final LIRInstructionClass<SPARCOP3Op> TYPE = LIRInstructionClass.create(SPARCOP3Op.class);
    public static final SPARCLIRInstructionMixin.SizeEstimate SIZE = SPARCLIRInstructionMixin.SizeEstimate.create(1);
    @Opcode
    private final SPARCAssembler.Op3s op3;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue rs1;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
    protected Value rs2;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue rd;
    @LIRInstruction.State
    protected LIRFrameState state;

    public static SPARCOP3Op newUnary(SPARCAssembler.Op3s op3, Value rs2, AllocatableValue rd) {
        return SPARCOP3Op.newUnary(op3, rs2, rd, null);
    }

    public static SPARCOP3Op newUnary(SPARCAssembler.Op3s op3, Value rs2, AllocatableValue rd, LIRFrameState state) {
        return new SPARCOP3Op(op3, (AllocatableValue)SPARC.g0.asValue((ValueKind)LIRKind.value(rs2.getPlatformKind())), rs2, rd, state);
    }

    public static SPARCOP3Op newBinaryVoid(SPARCAssembler.Op3s op3, AllocatableValue rs1, Value rs2) {
        return SPARCOP3Op.newBinaryVoid(op3, rs1, rs2, null);
    }

    public static SPARCOP3Op newBinaryVoid(SPARCAssembler.Op3s op3, AllocatableValue rs1, Value rs2, LIRFrameState state) {
        return new SPARCOP3Op(op3, rs1, rs2, (AllocatableValue)SPARC.g0.asValue((ValueKind)LIRKind.value(rs2.getPlatformKind())), state);
    }

    public SPARCOP3Op(SPARCAssembler.Op3s op3, AllocatableValue rs1, Value rs2, AllocatableValue rd) {
        this(op3, rs1, rs2, rd, null);
    }

    public SPARCOP3Op(SPARCAssembler.Op3s op3, AllocatableValue rs1, Value rs2, AllocatableValue rd, LIRFrameState state) {
        super(TYPE, SIZE);
        this.op3 = op3;
        this.rs1 = rs1;
        this.rs2 = rs2;
        this.rd = rd;
        this.state = state;
    }

    @Override
    protected void emitCode(CompilationResultBuilder crb, SPARCMacroAssembler masm) {
        this.getDelayedControlTransfer().emitControlTransfer(crb, masm);
        if (this.state != null) {
            crb.recordImplicitException(masm.position(), this.state);
        }
        SPARCOP3Op.emitOp3(masm, this.op3, (Value)this.rs1, this.rs2, (Value)this.rd);
    }

    public static void emitOp3(SPARCMacroAssembler masm, SPARCAssembler.Op3s op3, Value rs1, Value rs2) {
        SPARCOP3Op.emitOp3(masm, op3, rs1, rs2, (Value)SPARC.g0.asValue((ValueKind)LIRKind.value(rs2.getPlatformKind())));
    }

    public static void emitOp3(SPARCMacroAssembler masm, SPARCAssembler.Op3s op3, Value rs1, Value rs2, Value rd) {
        assert (ValueUtil.isRegister((Value)rs1)) : rs1;
        if (LIRValueUtil.isJavaConstant(rs2)) {
            JavaConstant constant = LIRValueUtil.asJavaConstant(rs2);
            long simm13 = constant.isNull() ? 0L : constant.asLong();
            assert (SPARCAssembler.isSimm13(constant));
            SPARCAssembler.Op3Op.emit(masm, op3, ValueUtil.asRegister((Value)rs1), (int)simm13, ValueUtil.asRegister((Value)rd));
        } else if (ValueUtil.isRegister((Value)rs2)) {
            SPARCAssembler.Op3Op.emit(masm, op3, ValueUtil.asRegister((Value)rs1), ValueUtil.asRegister((Value)rs2), ValueUtil.asRegister((Value)rd));
        } else {
            throw GraalError.shouldNotReachHere(String.format("Got values a: %s b: %s", rs1, rs2));
        }
    }
}

