/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.ssa;

import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;

final class SSAVerifier {
    private final LIR lir;
    private final BitSet visited;
    private final HashMap<Value, Entry> defined;
    private AbstractBlockBase<?> currentBlock;

    SSAVerifier(LIR lir) {
        this.lir = lir;
        this.visited = new BitSet(lir.getControlFlowGraph().getBlocks().length);
        this.defined = new HashMap();
    }

    public boolean verify() {
        DebugContext debug = this.lir.getDebug();
        try (DebugContext.Scope s = debug.scope((Object)"SSAVerifier", this.lir);){
            for (AbstractBlockBase block : this.lir.getControlFlowGraph().getBlocks()) {
                this.doBlock(block);
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        return true;
    }

    private void doBlock(AbstractBlockBase<?> b) {
        if (this.visited.get(b.getId())) {
            return;
        }
        for (AbstractBlockBase pred : b.getPredecessors()) {
            if (b.isLoopHeader() && pred.isLoopEnd()) continue;
            this.doBlock(pred);
        }
        try (Indent indent = this.lir.getDebug().logAndIndent(2, "handle block %s", b);){
            assert (this.verifyBlock(b));
        }
    }

    private boolean verifyBlock(AbstractBlockBase<?> block) {
        this.currentBlock = block;
        assert (!this.visited.get(block.getId())) : "Block already visited: " + block;
        this.visited.set(block.getId());
        for (LIRInstruction op : this.lir.getLIRforBlock(block)) {
            op.visitEachAlive(this::useConsumer);
            op.visitEachState(this::useConsumer);
            op.visitEachInput(this::useConsumer);
            op.visitEachTemp(this::defConsumer);
            op.visitEachOutput(this::defConsumer);
        }
        this.currentBlock = null;
        return true;
    }

    private void useConsumer(LIRInstruction inst, Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
        if (SSAVerifier.shouldProcess(value)) assert (this.defined.containsKey(value) || flags.contains((Object)LIRInstruction.OperandFlag.UNINITIALIZED)) : String.format("Value %s used at instruction %s in block %s but never defined", value, inst, this.currentBlock);
    }

    private void defConsumer(LIRInstruction inst, Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
        if (SSAVerifier.shouldProcess(value)) {
            assert (!this.defined.containsKey(value)) : String.format("Value %s redefined at %s but never defined (previous definition %s in block %s)", value, inst, Entry.access$000(this.defined.get(value)), Entry.access$100(this.defined.get(value)));
            this.defined.put(value, new Entry(inst, this.currentBlock));
        }
    }

    private static boolean shouldProcess(Value value) {
        return !value.equals((Object)Value.ILLEGAL) && !LIRValueUtil.isConstantValue(value) && !ValueUtil.isRegister((Value)value) && !LIRValueUtil.isStackSlotValue(value);
    }

    private static class Entry {
        private final LIRInstruction inst;
        private final AbstractBlockBase<?> block;

        Entry(LIRInstruction inst, AbstractBlockBase<?> block) {
            this.inst = inst;
            this.block = block;
        }

        static /* synthetic */ LIRInstruction access$000(Entry x0) {
            return x0.inst;
        }

        static /* synthetic */ AbstractBlockBase access$100(Entry x0) {
            return x0.block;
        }
    }
}

