/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.stackslotalloc;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Deque;
import java.util.EnumSet;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.lir.InstructionValueConsumer;
import org.graalvm.compiler.lir.InstructionValueProcedure;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.stackslotalloc.StackInterval;

final class FixPointIntervalBuilder {
    private final BlockMap<BitSet> liveInMap;
    private final BlockMap<BitSet> liveOutMap;
    private final LIR lir;
    private final int maxOpId;
    private final StackInterval[] stackSlotMap;
    private final EconomicSet<LIRInstruction> usePos;
    private static final CounterKey uninitializedSlots = DebugContext.counter("StackSlotAllocator[uninitializedSlots]");

    FixPointIntervalBuilder(LIR lir, StackInterval[] stackSlotMap, int maxOpId) {
        this.lir = lir;
        this.stackSlotMap = stackSlotMap;
        this.maxOpId = maxOpId;
        this.liveInMap = new BlockMap(lir.getControlFlowGraph());
        this.liveOutMap = new BlockMap(lir.getControlFlowGraph());
        this.usePos = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
    }

    EconomicSet<LIRInstruction> build() {
        ArrayDeque worklist = new ArrayDeque();
        AbstractBlockBase[] blocks = this.lir.getControlFlowGraph().getBlocks();
        for (int i = blocks.length - 1; i >= 0; --i) {
            worklist.add(blocks[i]);
        }
        for (AbstractBlockBase block : this.lir.getControlFlowGraph().getBlocks()) {
            this.liveInMap.put(block, new BitSet(this.stackSlotMap.length));
        }
        while (!worklist.isEmpty()) {
            AbstractBlockBase block = (AbstractBlockBase)worklist.poll();
            this.processBlock(block, worklist);
        }
        return this.usePos;
    }

    private boolean updateOutBlock(AbstractBlockBase<?> block) {
        BitSet union = new BitSet(this.stackSlotMap.length);
        for (AbstractBlockBase succ : block.getSuccessors()) {
            union.or(this.liveInMap.get(succ));
        }
        BitSet outSet = this.liveOutMap.get(block);
        if (outSet == null || !union.equals(outSet)) {
            this.liveOutMap.put(block, union);
            return true;
        }
        return false;
    }

    private void processBlock(AbstractBlockBase<?> block, Deque<AbstractBlockBase<?>> worklist) {
        DebugContext debug = this.lir.getDebug();
        if (this.updateOutBlock(block)) {
            try (Indent indent = debug.logAndIndent("handle block %s", block);){
                ArrayList<LIRInstruction> instructions = this.lir.getLIRforBlock(block);
                BitSet outSet = this.liveOutMap.get(block);
                this.markOutInterval(outSet, FixPointIntervalBuilder.getBlockEnd(instructions));
                this.printLiveSet("liveOut", outSet);
                BlockClosure closure = new BlockClosure((BitSet)outSet.clone());
                for (int i = instructions.size() - 1; i >= 0; --i) {
                    LIRInstruction inst = instructions.get(i);
                    closure.processInstructionBottomUp(inst);
                }
                for (AbstractBlockBase b : block.getPredecessors()) {
                    worklist.add(b);
                }
                BitSet inSet = closure.getCurrentSet();
                this.liveInMap.put(block, inSet);
                this.markInInterval(inSet, FixPointIntervalBuilder.getBlockBegin(instructions));
                this.printLiveSet("liveIn", inSet);
            }
        }
    }

    private void printLiveSet(String label, BitSet liveSet) {
        DebugContext debug = this.lir.getDebug();
        if (debug.isLogEnabled()) {
            try (Indent indent = debug.logAndIndent(label);){
                debug.log("%s", (Object)this.liveSetToString(liveSet));
            }
        }
    }

    private String liveSetToString(BitSet liveSet) {
        StringBuilder sb = new StringBuilder();
        int i = liveSet.nextSetBit(0);
        while (i >= 0) {
            StackInterval interval = this.getIntervalFromStackId(i);
            sb.append((Object)interval.getOperand()).append(" ");
            i = liveSet.nextSetBit(i + 1);
        }
        return sb.toString();
    }

    private void markOutInterval(BitSet outSet, int blockEndOpId) {
        DebugContext debug = this.lir.getDebug();
        int i = outSet.nextSetBit(0);
        while (i >= 0) {
            StackInterval interval = this.getIntervalFromStackId(i);
            debug.log("mark live operand: %s", (Object)interval.getOperand());
            interval.addTo(blockEndOpId);
            i = outSet.nextSetBit(i + 1);
        }
    }

    private void markInInterval(BitSet inSet, int blockFirstOpId) {
        DebugContext debug = this.lir.getDebug();
        int i = inSet.nextSetBit(0);
        while (i >= 0) {
            StackInterval interval = this.getIntervalFromStackId(i);
            debug.log("mark live operand: %s", (Object)interval.getOperand());
            interval.addFrom(blockFirstOpId);
            i = inSet.nextSetBit(i + 1);
        }
    }

    private StackInterval get(VirtualStackSlot stackSlot) {
        return this.stackSlotMap[stackSlot.getId()];
    }

    private void put(VirtualStackSlot stackSlot, StackInterval interval) {
        this.stackSlotMap[stackSlot.getId()] = interval;
    }

    private StackInterval getOrCreateInterval(VirtualStackSlot stackSlot) {
        StackInterval interval = this.get(stackSlot);
        if (interval == null) {
            interval = new StackInterval(stackSlot, stackSlot.getValueKind());
            this.put(stackSlot, interval);
        }
        return interval;
    }

    private StackInterval getIntervalFromStackId(int id) {
        return this.stackSlotMap[id];
    }

    private static int getBlockBegin(ArrayList<LIRInstruction> instructions) {
        return instructions.get(0).id();
    }

    private static int getBlockEnd(ArrayList<LIRInstruction> instructions) {
        return instructions.get(instructions.size() - 1).id() + 1;
    }

    private final class BlockClosure {
        private final BitSet currentSet;
        InstructionValueConsumer useConsumer = new InstructionValueConsumer(){

            @Override
            public void visitValue(LIRInstruction inst, Value operand, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
                if (LIRValueUtil.isVirtualStackSlot(operand)) {
                    DebugContext debug = FixPointIntervalBuilder.this.lir.getDebug();
                    VirtualStackSlot vslot = LIRValueUtil.asVirtualStackSlot(operand);
                    BlockClosure.this.addUse(vslot, inst, flags);
                    BlockClosure.this.addRegisterHint(inst, vslot, mode, flags, false);
                    FixPointIntervalBuilder.this.usePos.add((Object)inst);
                    debug.log("set operand: %s", operand);
                    BlockClosure.this.currentSet.set(vslot.getId());
                }
            }
        };
        InstructionValueConsumer defConsumer = new InstructionValueConsumer(){

            @Override
            public void visitValue(LIRInstruction inst, Value operand, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
                if (LIRValueUtil.isVirtualStackSlot(operand)) {
                    DebugContext debug = FixPointIntervalBuilder.this.lir.getDebug();
                    VirtualStackSlot vslot = LIRValueUtil.asVirtualStackSlot(operand);
                    BlockClosure.this.addDef(vslot, inst);
                    BlockClosure.this.addRegisterHint(inst, vslot, mode, flags, true);
                    FixPointIntervalBuilder.this.usePos.add((Object)inst);
                    debug.log("clear operand: %s", operand);
                    BlockClosure.this.currentSet.clear(vslot.getId());
                }
            }
        };

        private BlockClosure(BitSet set) {
            this.currentSet = set;
        }

        private BitSet getCurrentSet() {
            return this.currentSet;
        }

        private void processInstructionBottomUp(LIRInstruction op) {
            DebugContext debug = FixPointIntervalBuilder.this.lir.getDebug();
            try (Indent indent = debug.logAndIndent("handle op %d, %s", op.id(), (Object)op);){
                op.visitEachTemp(this.defConsumer);
                op.visitEachOutput(this.defConsumer);
                op.visitEachAlive(this.useConsumer);
                op.visitEachState(this.useConsumer);
                op.visitEachInput(this.useConsumer);
            }
        }

        private void addUse(VirtualStackSlot stackSlot, LIRInstruction inst, EnumSet<LIRInstruction.OperandFlag> flags) {
            StackInterval interval = FixPointIntervalBuilder.this.getOrCreateInterval(stackSlot);
            if (flags.contains((Object)LIRInstruction.OperandFlag.UNINITIALIZED)) {
                DebugContext debug = FixPointIntervalBuilder.this.lir.getDebug();
                if (debug.isCountEnabled() && (interval.from() != 0 || interval.to() != FixPointIntervalBuilder.this.maxOpId)) {
                    uninitializedSlots.increment(debug);
                }
                interval.addFrom(0);
                interval.addTo(FixPointIntervalBuilder.this.maxOpId);
            } else {
                interval.addTo(inst.id());
            }
        }

        private void addDef(VirtualStackSlot stackSlot, LIRInstruction inst) {
            StackInterval interval = FixPointIntervalBuilder.this.getOrCreateInterval(stackSlot);
            interval.addFrom(inst.id());
        }

        void addRegisterHint(final LIRInstruction op, final VirtualStackSlot targetValue, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags, final boolean hintAtDef) {
            if (flags.contains((Object)LIRInstruction.OperandFlag.HINT)) {
                InstructionValueProcedure proc = new InstructionValueProcedure(){

                    @Override
                    public Value doValue(LIRInstruction instruction, Value registerHint, LIRInstruction.OperandMode vaueMode, EnumSet<LIRInstruction.OperandFlag> valueFlags) {
                        if (LIRValueUtil.isVirtualStackSlot(registerHint)) {
                            StackInterval from = FixPointIntervalBuilder.this.getOrCreateInterval((VirtualStackSlot)registerHint);
                            StackInterval to = FixPointIntervalBuilder.this.getOrCreateInterval(targetValue);
                            if (hintAtDef) {
                                to.setLocationHint(from);
                            } else {
                                from.setLocationHint(to);
                            }
                            DebugContext debug = FixPointIntervalBuilder.this.lir.getDebug();
                            if (debug.isLogEnabled()) {
                                debug.log("operation %s at opId %d: added hint from interval %s to %s", op, (Object)op.id(), (Object)from, (Object)to);
                            }
                            return registerHint;
                        }
                        return null;
                    }
                };
                op.forEachRegisterHint((Value)targetValue, mode, proc);
            }
        }
    }
}

