/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class GetObjectAddressNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<GetObjectAddressNode> TYPE = NodeClass.create(GetObjectAddressNode.class);
    @Node.Input
    ValueNode object;

    public GetObjectAddressNode(ValueNode obj) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(JavaKind.Long));
        this.object = obj;
    }

    @Node.NodeIntrinsic
    public static native long get(Object var0);

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        Variable obj = gen.getLIRGeneratorTool().newVariable(LIRKind.unknownReference(gen.getLIRGeneratorTool().target().arch.getWordKind()));
        gen.getLIRGeneratorTool().emitMove(obj, gen.operand(this.object));
        gen.setResult(this, (Value)obj);
    }

    @Override
    public boolean verify() {
        assert (this.graph().getGuardsStage().areFrameStatesAtDeopts() || this.graph().method().getAnnotation(Snippet.class) != null) : "GetObjectAddressNode can't be used directly until frame states are fixed";
        return super.verify();
    }
}

