/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.ValueProxy;

@NodeInfo
public abstract class UnaryOpLogicNode
extends LogicNode
implements LIRLowerable,
Canonicalizable.Unary<ValueNode> {
    public static final NodeClass<UnaryOpLogicNode> TYPE = NodeClass.create(UnaryOpLogicNode.class);
    @Node.Input
    protected ValueNode value;

    @Override
    public ValueNode getValue() {
        return this.value;
    }

    public UnaryOpLogicNode(NodeClass<? extends UnaryOpLogicNode> c, ValueNode value) {
        super((NodeClass<? extends LogicNode>)c);
        assert (value != null);
        this.value = value;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
    }

    public Stamp getSucceedingStampForValue(boolean negated, Stamp valueStamp) {
        Stamp succStamp = this.getSucceedingStampForValue(negated);
        if (succStamp != null) {
            succStamp = succStamp.join(valueStamp);
        }
        return succStamp;
    }

    public abstract Stamp getSucceedingStampForValue(boolean var1);

    public abstract TriState tryFold(Stamp var1);

    @Override
    public TriState implies(boolean thisNegated, LogicNode other) {
        if (other instanceof UnaryOpLogicNode) {
            Stamp succStamp;
            TriState fold;
            UnaryOpLogicNode unaryY = (UnaryOpLogicNode)other;
            if ((this.getValue() == unaryY.getValue() || UnaryOpLogicNode.skipThroughPisAndProxies(this.getValue()) == UnaryOpLogicNode.skipThroughPisAndProxies(unaryY.getValue())) && (fold = unaryY.tryFold(succStamp = this.getSucceedingStampForValue(thisNegated))).isKnown()) {
                return fold;
            }
        }
        return super.implies(thisNegated, other);
    }

    private static ValueNode skipThroughPisAndProxies(ValueNode node) {
        ValueNode n = node;
        while (n != null) {
            if (n instanceof PiNode) {
                n = ((PiNode)n).getOriginalNode();
                continue;
            }
            if (!(n instanceof ValueProxy)) break;
            n = ((ValueProxy)((Object)n)).getOriginalNode();
        }
        return n;
    }
}

