/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.CompressionNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.UnaryOpLogicNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ConvertNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.type.NarrowOopStamp;
import org.graalvm.compiler.nodes.type.StampTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2)
public final class IsNullNode
extends UnaryOpLogicNode
implements LIRLowerable,
Virtualizable {
    public static final NodeClass<IsNullNode> TYPE = NodeClass.create(IsNullNode.class);
    private final JavaConstant nullConstant;

    private IsNullNode(ValueNode object, JavaConstant nullConstant) {
        super(TYPE, object);
        this.nullConstant = nullConstant;
        assert (object != null);
    }

    public IsNullNode(ValueNode object) {
        this(object, JavaConstant.NULL_POINTER);
        IsNullNode.assertNonNarrow(object);
    }

    public JavaConstant nullConstant() {
        return this.nullConstant;
    }

    public static LogicNode create(ValueNode forValue) {
        IsNullNode.assertNonNarrow(forValue);
        return IsNullNode.canonicalized(null, forValue, JavaConstant.NULL_POINTER);
    }

    public static LogicNode create(ValueNode forValue, JavaConstant nullConstant) {
        assert (nullConstant.isNull()) : "Null constant is not null: " + nullConstant;
        return IsNullNode.canonicalized(null, forValue, nullConstant);
    }

    private static void assertNonNarrow(ValueNode object) {
        assert (!(object.stamp(NodeView.DEFAULT) instanceof NarrowOopStamp)) : "Value to compare against null is a NarrowOop" + object;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
    }

    @Override
    public boolean verify() {
        this.assertTrue(this.getValue() != null, "is null input must not be null", new Object[0]);
        this.assertTrue(this.getValue().stamp(NodeView.DEFAULT) instanceof AbstractPointerStamp, "input must be a pointer not %s", this.getValue().stamp(NodeView.DEFAULT));
        return super.verify();
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        return IsNullNode.canonicalized(this, forValue, this.nullConstant);
    }

    private static LogicNode canonicalized(IsNullNode node, ValueNode forValue, JavaConstant forNullConstant) {
        JavaConstant nullConstant = forNullConstant;
        ValueNode value = forValue;
        while (true) {
            if (StampTool.isPointerAlwaysNull(value)) {
                return LogicConstantNode.tautology();
            }
            if (StampTool.isPointerNonNull(value)) {
                return LogicConstantNode.contradiction();
            }
            if (!(value instanceof ConvertNode)) break;
            ConvertNode convertNode = (ConvertNode)((Object)value);
            if (convertNode.mayNullCheckSkipConversion()) {
                value = convertNode.getValue();
                continue;
            }
            if (!(value instanceof CompressionNode)) break;
            CompressionNode compressionNode = (CompressionNode)value;
            nullConstant = compressionNode.nullConstant();
            value = compressionNode.getValue();
        }
        return node != null && value == forValue ? node : new IsNullNode(value, nullConstant);
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.getValue());
        TriState fold = this.tryFold(alias.stamp(NodeView.DEFAULT));
        if (fold != TriState.UNKNOWN) {
            tool.replaceWithValue(LogicConstantNode.forBoolean(fold.isTrue(), this.graph()));
        }
    }

    @Override
    public Stamp getSucceedingStampForValue(boolean negated) {
        AbstractPointerStamp pointerStamp = (AbstractPointerStamp)this.getValue().stamp(NodeView.DEFAULT).unrestricted();
        return negated ? pointerStamp.asNonNull() : pointerStamp.asAlwaysNull();
    }

    @Override
    public TriState tryFold(Stamp valueStamp) {
        if (valueStamp instanceof ObjectStamp) {
            ObjectStamp objectStamp = (ObjectStamp)valueStamp;
            if (objectStamp.alwaysNull()) {
                return TriState.TRUE;
            }
            if (objectStamp.nonNull()) {
                return TriState.FALSE;
            }
        }
        return TriState.UNKNOWN;
    }
}

