/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.SerializableConstant;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.ArithmeticStamp;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.serviceprovider.BufferUtil;

@NodeInfo(cycles=NodeCycles.CYCLES_1)
public final class ReinterpretNode
extends UnaryNode
implements ArithmeticLIRLowerable {
    public static final NodeClass<ReinterpretNode> TYPE = NodeClass.create(ReinterpretNode.class);

    protected ReinterpretNode(JavaKind to, ValueNode value) {
        this(StampFactory.forKind(to), value);
    }

    protected ReinterpretNode(Stamp to, ValueNode value) {
        super(TYPE, ReinterpretNode.getReinterpretStamp(to, value.stamp(NodeView.DEFAULT)), value);
        assert (to instanceof ArithmeticStamp);
    }

    public static ValueNode create(JavaKind to, ValueNode value, NodeView view) {
        return ReinterpretNode.create(StampFactory.forKind(to), value, view);
    }

    public static ValueNode create(Stamp to, ValueNode value, NodeView view) {
        return ReinterpretNode.canonical(null, to, value, view);
    }

    private static SerializableConstant evalConst(Stamp stamp, SerializableConstant c) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[c.getSerializedSize()]).order(ByteOrder.nativeOrder());
        c.serialize(buffer);
        BufferUtil.asBaseBuffer(buffer).rewind();
        SerializableConstant ret = ((ArithmeticStamp)stamp).deserialize(buffer);
        assert (!buffer.hasRemaining());
        return ret;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        NodeView view = NodeView.from(tool);
        return ReinterpretNode.canonical(this, this.stamp(view), forValue, view);
    }

    public static ValueNode canonical(ReinterpretNode node, Stamp forStamp, ValueNode forValue, NodeView view) {
        if (forValue.isConstant()) {
            return ConstantNode.forConstant(forStamp, (Constant)ReinterpretNode.evalConst(forStamp, (SerializableConstant)forValue.asConstant()), null);
        }
        if (forStamp.isCompatible(forValue.stamp(view))) {
            return forValue;
        }
        if (forValue instanceof ReinterpretNode) {
            ReinterpretNode reinterpret = (ReinterpretNode)forValue;
            return new ReinterpretNode(forStamp, reinterpret.getValue());
        }
        return node != null ? node : new ReinterpretNode(forStamp, forValue);
    }

    private static IntegerStamp floatToInt(FloatStamp stamp) {
        long exponentMask;
        int bits = stamp.getBits();
        long signBit = 1L << bits - 1;
        if (bits == 64) {
            exponentMask = Double.doubleToRawLongBits(Double.POSITIVE_INFINITY);
        } else {
            assert (bits == 32);
            exponentMask = Float.floatToRawIntBits(Float.POSITIVE_INFINITY);
        }
        long positiveInfinity = exponentMask;
        long negativeInfinity = CodeUtil.signExtend((long)(signBit | positiveInfinity), (int)bits);
        long negativeZero = CodeUtil.signExtend((long)(signBit | 0L), (int)bits);
        if (stamp.isNaN()) {
            return IntegerStamp.create(bits, negativeInfinity + 1L, CodeUtil.maxValue((int)bits), exponentMask, CodeUtil.mask((int)bits));
        }
        long upperBound = stamp.isNonNaN() ? (stamp.upperBound() < 0.0 ? (stamp.lowerBound() > Double.NEGATIVE_INFINITY ? negativeInfinity - 1L : negativeInfinity) : (stamp.upperBound() == 0.0 ? 0L : (stamp.upperBound() < Double.POSITIVE_INFINITY ? positiveInfinity - 1L : positiveInfinity))) : CodeUtil.maxValue((int)bits);
        long lowerBound = stamp.lowerBound() > 0.0 ? (stamp.isNonNaN() ? 1L : negativeInfinity + 1L) : (stamp.upperBound() == Double.NEGATIVE_INFINITY ? negativeInfinity : (stamp.upperBound() < 0.0 ? negativeZero + 1L : negativeZero));
        return StampFactory.forInteger(bits, lowerBound, upperBound);
    }

    private static FloatStamp intToFloat(IntegerStamp stamp) {
        boolean nonNaN;
        double upperBound;
        double maxPositive;
        double minPositive;
        long exponentMask;
        int bits = stamp.getBits();
        long signBit = 1L << bits - 1;
        if (bits == 64) {
            exponentMask = Double.doubleToRawLongBits(Double.POSITIVE_INFINITY);
            minPositive = Double.MIN_VALUE;
            maxPositive = Double.MAX_VALUE;
        } else {
            assert (bits == 32);
            exponentMask = Float.floatToRawIntBits(Float.POSITIVE_INFINITY);
            minPositive = 1.4E-45f;
            maxPositive = 3.4028234663852886E38;
        }
        long significandMask = CodeUtil.mask((int)bits) & ((signBit | exponentMask) ^ 0xFFFFFFFFFFFFFFFFL);
        long positiveInfinity = exponentMask;
        long negativeInfinity = CodeUtil.signExtend((long)(signBit | positiveInfinity), (int)bits);
        long negativeZero = CodeUtil.signExtend((long)(signBit | 0L), (int)bits);
        if ((stamp.downMask() & exponentMask) == exponentMask && (stamp.downMask() & significandMask) != 0L) {
            return new FloatStamp(bits, Double.NaN, Double.NaN, false);
        }
        if (stamp.upperBound() < negativeInfinity) {
            upperBound = stamp.lowerBound() > negativeZero ? -minPositive : -0.0;
        } else if (stamp.upperBound() < 0L) {
            if (stamp.lowerBound() > negativeInfinity) {
                return new FloatStamp(bits, Double.NaN, Double.NaN, false);
            }
            upperBound = stamp.lowerBound() == negativeInfinity ? Double.NEGATIVE_INFINITY : (stamp.lowerBound() > negativeZero ? -minPositive : -0.0);
        } else {
            upperBound = stamp.upperBound() == 0L ? 0.0 : (stamp.upperBound() < positiveInfinity ? maxPositive : Double.POSITIVE_INFINITY);
        }
        if (stamp.lowerBound() > positiveInfinity) {
            return new FloatStamp(bits, Double.NaN, Double.NaN, false);
        }
        double lowerBound = stamp.lowerBound() == positiveInfinity ? Double.POSITIVE_INFINITY : (stamp.lowerBound() > 0L ? minPositive : (stamp.lowerBound() > negativeInfinity ? 0.0 : Double.NEGATIVE_INFINITY));
        if ((stamp.upMask() & exponentMask) != exponentMask) {
            nonNaN = true;
        } else {
            boolean negativeNaNBlock = stamp.lowerBound() < 0L && stamp.upperBound() > negativeInfinity;
            boolean positiveNaNBlock = stamp.upperBound() > positiveInfinity;
            nonNaN = !negativeNaNBlock && !positiveNaNBlock;
        }
        return new FloatStamp(bits, lowerBound, upperBound, nonNaN);
    }

    private static Stamp getReinterpretStamp(Stamp toStamp, Stamp fromStamp) {
        if (toStamp instanceof IntegerStamp && fromStamp instanceof FloatStamp) {
            return ReinterpretNode.floatToInt((FloatStamp)fromStamp);
        }
        if (toStamp instanceof FloatStamp && fromStamp instanceof IntegerStamp) {
            return ReinterpretNode.intToFloat((IntegerStamp)fromStamp);
        }
        return toStamp;
    }

    @Override
    public boolean inferStamp() {
        return this.updateStamp(ReinterpretNode.getReinterpretStamp(this.stamp(NodeView.DEFAULT), this.getValue().stamp(NodeView.DEFAULT)));
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        LIRKind kind = builder.getLIRGeneratorTool().getLIRKind(this.stamp(NodeView.DEFAULT));
        builder.setResult(this, gen.emitReinterpret(kind, builder.operand(this.getValue())));
    }

    public static ValueNode reinterpret(JavaKind toKind, ValueNode value) {
        return value.graph().unique(new ReinterpretNode(toKind, value));
    }
}

