/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import java.nio.ByteOrder;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.ReinterpretNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2)
public final class UnpackEndianHalfNode
extends UnaryNode
implements Lowerable {
    public static final NodeClass<UnpackEndianHalfNode> TYPE = NodeClass.create(UnpackEndianHalfNode.class);
    private final boolean firstHalf;

    protected UnpackEndianHalfNode(ValueNode value, boolean firstHalf) {
        super(TYPE, StampFactory.forKind(JavaKind.Int), value);
        assert (value.getStackKind() == JavaKind.Double || value.getStackKind() == JavaKind.Long) : "unexpected kind " + value.getStackKind();
        this.firstHalf = firstHalf;
    }

    public static ValueNode create(ValueNode value, boolean firstHalf, NodeView view) {
        if (value.isConstant() && value.asConstant().isDefaultForKind()) {
            return ConstantNode.defaultForKind(JavaKind.Int);
        }
        return new UnpackEndianHalfNode(value, firstHalf);
    }

    public boolean isFirstHalf() {
        return this.firstHalf;
    }

    @Override
    public Node canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (forValue.isDefaultConstant()) {
            return ConstantNode.defaultForKind(this.stamp.getStackKind());
        }
        return this;
    }

    @Override
    public void lower(LoweringTool tool) {
        tool.getLowerer().lower(this, tool);
    }

    public void lower(ByteOrder byteOrder) {
        ValueNode result = this.value;
        if (this.value.getStackKind() == JavaKind.Double) {
            result = this.graph().unique(new ReinterpretNode(JavaKind.Long, this.value));
        }
        if (byteOrder == ByteOrder.BIG_ENDIAN == this.firstHalf) {
            result = this.graph().unique(new UnsignedRightShiftNode(result, ConstantNode.forInt(32, this.graph())));
        }
        result = IntegerConvertNode.convert(result, StampFactory.forKind(JavaKind.Int), this.graph(), NodeView.DEFAULT);
        this.replaceAtUsagesAndDelete(result);
    }
}

