/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.debug;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Node is literally a blackhole", size=NodeSize.SIZE_UNKNOWN)
public final class BlackholeNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<BlackholeNode> TYPE = NodeClass.create(BlackholeNode.class);
    @Node.Input
    ValueNode value;

    public BlackholeNode(ValueNode value) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forVoid());
        this.value = value;
    }

    public ValueNode getValue() {
        return this.value;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.getLIRGeneratorTool().emitBlackhole(gen.operand(this.value));
    }
}

