/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class UnboxNode
extends FixedWithNextNode
implements Virtualizable,
Lowerable,
Canonicalizable.Unary<ValueNode> {
    public static final NodeClass<UnboxNode> TYPE = NodeClass.create(UnboxNode.class);
    @Node.Input
    protected ValueNode value;
    protected final JavaKind boxingKind;

    @Override
    public ValueNode getValue() {
        return this.value;
    }

    public UnboxNode(ValueNode value, JavaKind boxingKind) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(boxingKind.getStackKind()));
        this.value = value;
        this.boxingKind = boxingKind;
    }

    public static ValueNode create(MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection, ValueNode value, JavaKind boxingKind) {
        ValueNode synonym = UnboxNode.findSynonym(metaAccess, constantReflection, value, boxingKind);
        if (synonym != null) {
            return synonym;
        }
        return new UnboxNode(value, boxingKind);
    }

    public JavaKind getBoxingKind() {
        return this.boxingKind;
    }

    @Override
    public void lower(LoweringTool tool) {
        tool.getLowerer().lower(this, tool);
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ResolvedJavaType expectedType;
        VirtualObjectNode virtual;
        ResolvedJavaType objectType;
        ValueNode alias = tool.getAlias(this.getValue());
        if (alias instanceof VirtualObjectNode && (objectType = (virtual = (VirtualObjectNode)alias).type()).equals(expectedType = tool.getMetaAccess().lookupJavaType(this.boxingKind.toBoxedJavaClass()))) {
            tool.replaceWithValue(tool.getEntry(virtual, 0));
        }
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (tool.allUsagesAvailable() && this.hasNoUsages() && StampTool.isPointerNonNull(forValue)) {
            return null;
        }
        ValueNode synonym = UnboxNode.findSynonym(tool.getMetaAccess(), tool.getConstantReflection(), forValue, this.boxingKind);
        if (synonym != null) {
            return synonym;
        }
        return this;
    }

    private static ValueNode findSynonym(MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection, ValueNode forValue, JavaKind boxingKind) {
        BoxNode box;
        if (forValue.isConstant()) {
            JavaConstant constant = forValue.asJavaConstant();
            JavaConstant unboxed = constantReflection.unboxPrimitive(constant);
            if (unboxed != null && unboxed.getJavaKind() == boxingKind) {
                return ConstantNode.forConstant(unboxed, metaAccess);
            }
        } else if (forValue instanceof BoxNode && boxingKind == (box = (BoxNode)forValue).getBoxingKind()) {
            return box.getValue();
        }
        return null;
    }
}

