/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.memory.AbstractMemoryCheckpoint;
import org.graalvm.compiler.nodes.memory.MemoryCheckpoint;

@NodeInfo(allowedUsageTypes={InputType.Memory})
public abstract class AccessMonitorNode
extends AbstractMemoryCheckpoint
implements MemoryCheckpoint,
DeoptimizingNode.DeoptBefore,
DeoptimizingNode.DeoptAfter {
    public static final NodeClass<AccessMonitorNode> TYPE = NodeClass.create(AccessMonitorNode.class);
    @Node.OptionalInput(value=InputType.State)
    FrameState stateBefore;
    @Node.Input
    ValueNode object;
    @Node.Input(value=InputType.Association)
    MonitorIdNode monitorId;

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public FrameState stateBefore() {
        return this.stateBefore;
    }

    @Override
    public void setStateBefore(FrameState f) {
        this.updateUsages(this.stateBefore, f);
        this.stateBefore = f;
    }

    public ValueNode object() {
        return this.object;
    }

    public void setObject(ValueNode lockedObject) {
        this.updateUsages(this.object, lockedObject);
        this.object = lockedObject;
    }

    public MonitorIdNode getMonitorId() {
        return this.monitorId;
    }

    protected AccessMonitorNode(NodeClass<? extends AccessMonitorNode> c, ValueNode object, MonitorIdNode monitorId) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)c, StampFactory.forVoid());
        this.object = object;
        this.monitorId = monitorId;
    }
}

