/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginStateSplitNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.KillingBeginNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.LoadExceptionObjectNode;
import org.graalvm.compiler.nodes.memory.MemoryCheckpoint;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8)
public final class ExceptionObjectNode
extends BeginStateSplitNode
implements Lowerable,
MemoryCheckpoint.Single {
    public static final NodeClass<ExceptionObjectNode> TYPE = NodeClass.create(ExceptionObjectNode.class);

    public ExceptionObjectNode(MetaAccessProvider metaAccess) {
        super((NodeClass<? extends BeginStateSplitNode>)TYPE, (Stamp)StampFactory.objectNonNull(TypeReference.createTrustedWithoutAssumptions(metaAccess.lookupJavaType(Throwable.class))));
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    @Override
    public void lower(LoweringTool tool) {
        if (this.graph().getGuardsStage() == StructuredGraph.GuardsStage.FIXED_DEOPTS) {
            LocationIdentity locationsKilledByInvoke = ((InvokeWithExceptionNode)this.predecessor()).getKilledLocationIdentity();
            AbstractBeginNode entry = this.graph().add(KillingBeginNode.create(locationsKilledByInvoke));
            LoadExceptionObjectNode loadException = this.graph().add(new LoadExceptionObjectNode(this.stamp(NodeView.DEFAULT)));
            loadException.setStateAfter(this.stateAfter());
            this.replaceAtUsages(InputType.Value, loadException);
            this.graph().replaceFixedWithFixed(this, entry);
            entry.graph().addAfterFixed(entry, loadException);
            loadException.lower(tool);
        }
    }

    @Override
    public boolean verify() {
        this.assertTrue(this.stateAfter() != null, "an exception handler needs a frame state", new Object[0]);
        this.assertTrue(this.stateAfter().stackSize() == 1 && this.stateAfter().stackAt(0).stamp(NodeView.DEFAULT).getStackKind() == JavaKind.Object, "an exception handler's frame state must have only the exception on the stack", new Object[0]);
        return super.verify();
    }
}

