/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.memory.MemoryMap;
import org.graalvm.compiler.nodes.memory.MemoryNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Extension, InputType.Memory}, cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class MemoryMapNode
extends FloatingNode
implements MemoryMap,
MemoryNode,
LIRLowerable {
    public static final NodeClass<MemoryMapNode> TYPE = NodeClass.create(MemoryMapNode.class);
    protected final List<LocationIdentity> locationIdentities;
    @Node.Input(value=InputType.Memory)
    NodeInputList<ValueNode> nodes;

    private boolean checkOrder(EconomicMap<LocationIdentity, MemoryNode> mmap) {
        for (int i = 0; i < this.locationIdentities.size(); ++i) {
            LocationIdentity locationIdentity = this.locationIdentities.get(i);
            ValueNode n = (ValueNode)this.nodes.get(i);
            this.assertTrue(mmap.get((Object)locationIdentity) == n, "iteration order of keys differs from values in input map", new Object[0]);
        }
        return true;
    }

    public MemoryMapNode(EconomicMap<LocationIdentity, MemoryNode> mmap) {
        super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.forVoid());
        int size = mmap.size();
        this.locationIdentities = new ArrayList<LocationIdentity>(size);
        this.nodes = new NodeInputList((Node)this, size);
        int index = 0;
        MapCursor cursor = mmap.getEntries();
        while (cursor.advance()) {
            this.locationIdentities.add((LocationIdentity)cursor.getKey());
            this.nodes.initialize(index, (ValueNode)cursor.getValue());
            ++index;
        }
        assert (this.checkOrder(mmap));
    }

    public boolean isEmpty() {
        if (this.locationIdentities.isEmpty()) {
            return true;
        }
        return this.locationIdentities.size() == 1 && this.nodes.get(0) instanceof StartNode;
    }

    @Override
    public MemoryNode getLastLocationAccess(LocationIdentity locationIdentity) {
        if (locationIdentity.isImmutable()) {
            return null;
        }
        int index = this.locationIdentities.indexOf(locationIdentity);
        if (index == -1) {
            index = this.locationIdentities.indexOf(LocationIdentity.any());
        }
        assert (index != -1);
        return (MemoryNode)this.nodes.get(index);
    }

    public Collection<LocationIdentity> getLocations() {
        return this.locationIdentities;
    }

    public EconomicMap<LocationIdentity, MemoryNode> toMap() {
        EconomicMap res = EconomicMap.create((Equivalence)Equivalence.DEFAULT, (int)this.locationIdentities.size());
        for (int i = 0; i < this.nodes.size(); ++i) {
            res.put((Object)this.locationIdentities.get(i), (Object)((MemoryNode)this.nodes.get(i)));
        }
        return res;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
    }
}

