/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.memory;

import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.memory.FloatingAccessNode;
import org.graalvm.compiler.nodes.memory.HeapAccess;
import org.graalvm.compiler.nodes.memory.MemoryCheckpoint;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="Read#{p#location/s}", allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public class VolatileReadNode
extends ReadNode
implements MemoryCheckpoint.Single {
    public static final NodeClass<VolatileReadNode> TYPE = NodeClass.create(VolatileReadNode.class);

    public VolatileReadNode(AddressNode address, LocationIdentity location, Stamp stamp, HeapAccess.BarrierType barrierType) {
        super((NodeClass<? extends ReadNode>)TYPE, address, location, stamp, (GuardingNode)null, barrierType, false, (FrameState)null);
        assert (GraalOptions.LateMembars.getValue(address.getOptions()).booleanValue());
    }

    @Override
    public FloatingAccessNode asFloatingNode() {
        throw new RuntimeException();
    }

    @Override
    public boolean canFloat() {
        return false;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    public boolean canNullCheck() {
        return false;
    }
}

