/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.memory;

import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.AbstractWriteNode;
import org.graalvm.compiler.nodes.memory.HeapAccess;
import org.graalvm.compiler.nodes.memory.LIRLowerableAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="Write#{p#location/s}")
public class WriteNode
extends AbstractWriteNode
implements LIRLowerableAccess,
Canonicalizable {
    public static final NodeClass<WriteNode> TYPE = NodeClass.create(WriteNode.class);
    private final boolean volatileAccess;

    public WriteNode(AddressNode address, LocationIdentity location, ValueNode value, HeapAccess.BarrierType barrierType, boolean volatileAccess) {
        super(TYPE, address, location, value, barrierType);
        this.volatileAccess = volatileAccess;
    }

    protected WriteNode(NodeClass<? extends WriteNode> c, AddressNode address, LocationIdentity location, ValueNode value, HeapAccess.BarrierType barrierType) {
        super(c, address, location, value, barrierType);
        this.volatileAccess = false;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        LIRKind writeKind = gen.getLIRGeneratorTool().getLIRKind(this.value().stamp(NodeView.DEFAULT));
        gen.getLIRGeneratorTool().getArithmetic().emitStore(writeKind, gen.operand(this.address), gen.operand(this.value()), gen.state(this));
    }

    @Override
    public boolean canNullCheck() {
        return !this.isVolatile();
    }

    @Override
    public Stamp getAccessStamp() {
        return this.value().stamp(NodeView.DEFAULT);
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (tool.canonicalizeReads() && this.hasExactlyOneUsage() && this.next() instanceof WriteNode) {
            WriteNode write = (WriteNode)this.next();
            if (write.lastLocationAccess == this && write.getAddress() == this.getAddress() && this.getAccessStamp().isCompatible(write.getAccessStamp()) && !this.isVolatile()) {
                write.setLastLocationAccess(this.getLastLocationAccess());
                return write;
            }
        }
        return this;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        if (this.isVolatile()) {
            return LocationIdentity.any();
        }
        return this.getLocationIdentity();
    }

    public boolean isVolatile() {
        return this.volatileAccess;
    }
}

