/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.type;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.serviceprovider.SpeculationReasonGroup;

public abstract class NarrowOopStamp
extends AbstractObjectStamp {
    private final CompressEncoding encoding;

    protected NarrowOopStamp(ResolvedJavaType type, boolean exactType, boolean nonNull, boolean alwaysNull, CompressEncoding encoding) {
        super(type, exactType, nonNull, alwaysNull);
        this.encoding = encoding;
    }

    @Override
    public void accept(SpeculationReasonGroup.SpeculationContextObject.Visitor v) {
        super.accept(v);
        v.visitLong(this.encoding.getBase());
        v.visitInt(this.encoding.getShift());
    }

    @Override
    protected abstract AbstractObjectStamp copyWith(ResolvedJavaType var1, boolean var2, boolean var3, boolean var4);

    public Stamp uncompressed() {
        return new ObjectStamp(this.type(), this.isExactType(), this.nonNull(), this.alwaysNull());
    }

    public CompressEncoding getEncoding() {
        return this.encoding;
    }

    @Override
    public LIRKind getLIRKind(LIRKindTool tool) {
        return tool.getNarrowOopKind();
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append('n');
        this.appendString(str);
        return str.toString();
    }

    @Override
    public boolean isCompatible(Stamp other) {
        if (this == other) {
            return true;
        }
        if (other instanceof NarrowOopStamp) {
            NarrowOopStamp narrow = (NarrowOopStamp)other;
            return this.encoding.equals(narrow.encoding);
        }
        return false;
    }

    @Override
    public abstract Constant readConstant(MemoryAccessProvider var1, Constant var2, long var3);

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.encoding.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NarrowOopStamp other = (NarrowOopStamp)obj;
        if (!this.encoding.equals(other.encoding)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public abstract boolean isCompatible(Constant var1);
}

