/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.virtual;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.virtual.AllocatedObjectNode;
import org.graalvm.compiler.nodes.virtual.LockState;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;

@NodeInfo(nameTemplate="VirtualInstance({p#objectId}) {p#type/s}")
public class VirtualInstanceNode
extends VirtualObjectNode {
    public static final NodeClass<VirtualInstanceNode> TYPE = NodeClass.create(VirtualInstanceNode.class);
    protected final ResolvedJavaType type;
    protected final ResolvedJavaField[] fields;

    public VirtualInstanceNode(ResolvedJavaType type, boolean hasIdentity) {
        this(type, type.getInstanceFields(true), hasIdentity);
    }

    public VirtualInstanceNode(ResolvedJavaType type, ResolvedJavaField[] fields, boolean hasIdentity) {
        this(TYPE, type, fields, hasIdentity);
    }

    protected VirtualInstanceNode(NodeClass<? extends VirtualInstanceNode> c, ResolvedJavaType type, boolean hasIdentity) {
        this(c, type, type.getInstanceFields(true), hasIdentity);
    }

    protected VirtualInstanceNode(NodeClass<? extends VirtualInstanceNode> c, ResolvedJavaType type, ResolvedJavaField[] fields, boolean hasIdentity) {
        super(c, type, hasIdentity);
        this.type = type;
        this.fields = fields;
    }

    @Override
    public ResolvedJavaType type() {
        return this.type;
    }

    @Override
    public int entryCount() {
        return this.fields.length;
    }

    public ResolvedJavaField field(int index) {
        return this.fields[index];
    }

    public ResolvedJavaField[] getFields() {
        return this.fields;
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name) {
            return super.toString(Verbosity.Name) + "(" + this.getObjectId() + ") " + this.type.toJavaName(false);
        }
        return super.toString(verbosity);
    }

    @Override
    public String entryName(int index) {
        return this.fields[index].getName();
    }

    public int fieldIndex(ResolvedJavaField field) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].equals(field)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int entryIndexForOffset(MetaAccessProvider metaAccess, long constantOffset, JavaKind expectedEntryKind) {
        return this.fieldIndex(this.type.findInstanceFieldWithOffset(constantOffset, expectedEntryKind));
    }

    @Override
    public JavaKind entryKind(int index) {
        assert (index >= 0 && index < this.fields.length);
        return this.fields[index].getJavaKind();
    }

    @Override
    public VirtualInstanceNode duplicate() {
        VirtualInstanceNode node = new VirtualInstanceNode(this.type, this.fields, super.hasIdentity());
        node.setNodeSourcePosition(this.getNodeSourcePosition());
        return node;
    }

    @Override
    public ValueNode getMaterializedRepresentation(FixedNode fixed, ValueNode[] entries, LockState locks) {
        AllocatedObjectNode node = new AllocatedObjectNode(this);
        node.setNodeSourcePosition(this.getNodeSourcePosition());
        return node;
    }
}

