/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.options;

import java.util.concurrent.atomic.AtomicReference;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;

public class ModifiableOptionValues
extends OptionValues {
    private final AtomicReference<UnmodifiableEconomicMap<OptionKey<?>, Object>> v = new AtomicReference();
    private static final EconomicMap<OptionKey<?>, Object> EMPTY_MAP = ModifiableOptionValues.newOptionMap();
    public static final Object UNSET_KEY = new Object();

    public ModifiableOptionValues(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
        super((UnmodifiableEconomicMap<OptionKey<?>, Object>)EMPTY_MAP);
        EconomicMap<OptionKey<?>, Object> map = ModifiableOptionValues.newOptionMap();
        ModifiableOptionValues.initMap(map, values);
        this.v.set((UnmodifiableEconomicMap<OptionKey<?>, Object>)map);
    }

    public void update(OptionKey<?> key, Object value) {
        EconomicMap newMap;
        UnmodifiableEconomicMap<OptionKey<?>, Object> expect;
        do {
            expect = this.v.get();
            newMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY, expect);
            if (value == UNSET_KEY) {
                newMap.removeKey(key);
                continue;
            }
            key.update(newMap, value);
            newMap.put(key, ModifiableOptionValues.encodeNull(value));
        } while (!this.v.compareAndSet(expect, (UnmodifiableEconomicMap<OptionKey<?>, Object>)newMap));
    }

    public void update(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
        EconomicMap newMap;
        UnmodifiableEconomicMap<OptionKey<?>, Object> expect;
        if (values.isEmpty()) {
            return;
        }
        do {
            expect = this.v.get();
            newMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY, expect);
            UnmodifiableMapCursor cursor = values.getEntries();
            while (cursor.advance()) {
                OptionKey key = (OptionKey)cursor.getKey();
                Object value = cursor.getValue();
                if (value == UNSET_KEY) {
                    newMap.removeKey((Object)key);
                    continue;
                }
                key.update(newMap, value);
                newMap.put((Object)key, ModifiableOptionValues.encodeNull(value));
            }
        } while (!this.v.compareAndSet(expect, (UnmodifiableEconomicMap<OptionKey<?>, Object>)newMap));
    }

    @Override
    protected <T> T get(OptionKey<T> key) {
        return OptionValues.get(this.v.get(), key);
    }

    @Override
    protected boolean containsKey(OptionKey<?> key) {
        return this.v.get().containsKey(key);
    }

    @Override
    public UnmodifiableEconomicMap<OptionKey<?>, Object> getMap() {
        return this.v.get();
    }
}

