/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.Phase;

public class AddressLoweringPhase
extends Phase {
    private final AddressLowering lowering;

    public AddressLoweringPhase(AddressLowering lowering) {
        this.lowering = lowering;
        assert (lowering != null);
    }

    @Override
    protected void run(StructuredGraph graph) {
        this.lowering.preProcess(graph);
        for (Node node : graph.getNodes()) {
            if (!(node instanceof OffsetAddressNode)) continue;
            OffsetAddressNode address = (OffsetAddressNode)node;
            AddressNode lowered = this.lowering.lower(address.getBase(), address.getOffset());
            this.lowering.postProcess(lowered);
            node.replaceAtUsages(lowered);
            GraphUtil.killWithUnusedFloatingInputs(node);
        }
    }

    public static abstract class AddressLowering {
        public void preProcess(StructuredGraph graph) {
        }

        public void postProcess(AddressNode lowered) {
        }

        public abstract AddressNode lower(ValueNode var1, ValueNode var2);
    }
}

