/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.MembarNode;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.VolatileReadNode;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.phases.Phase;

public class InsertMembarsPhase
extends Phase {
    @Override
    protected void run(StructuredGraph graph) {
        for (FixedAccessNode access : graph.getNodes(FixedAccessNode.TYPE)) {
            MembarNode postMembar;
            MembarNode preMembar;
            if (access instanceof VolatileReadNode) {
                ReadNode read = (ReadNode)access;
                preMembar = graph.add(new MembarNode(0));
                graph.addBeforeFixed(read, preMembar);
                postMembar = graph.add(new MembarNode(3));
                graph.addAfterFixed(read, postMembar);
                continue;
            }
            if (!(access instanceof WriteNode) || !((WriteNode)access).isVolatile()) continue;
            WriteNode write = (WriteNode)access;
            preMembar = graph.add(new MembarNode(10));
            graph.addBeforeFixed(write, preMembar);
            postMembar = graph.add(new MembarNode(12));
            graph.addAfterFixed(write, postMembar);
        }
    }

    @Override
    public float codeSizeIncrease() {
        return 3.0f;
    }
}

