/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common.inlining.info;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.phases.common.inlining.info.AbstractInlineInfo;
import org.graalvm.compiler.phases.common.inlining.info.elem.Inlineable;
import org.graalvm.compiler.phases.util.Providers;

public class ExactInlineInfo
extends AbstractInlineInfo {
    protected final ResolvedJavaMethod concrete;
    private Inlineable inlineableElement;
    private boolean suppressNullCheck;

    public ExactInlineInfo(Invoke invoke, ResolvedJavaMethod concrete) {
        super(invoke);
        this.concrete = concrete;
        assert (concrete != null);
    }

    public void suppressNullCheck() {
        this.suppressNullCheck = true;
    }

    @Override
    public EconomicSet<Node> inline(Providers providers, String reason) {
        return ExactInlineInfo.inline(this.invoke, this.concrete, this.inlineableElement, !this.suppressNullCheck, reason);
    }

    @Override
    public void tryToDevirtualizeInvoke(Providers providers) {
    }

    @Override
    public int numberOfMethods() {
        return 1;
    }

    @Override
    public ResolvedJavaMethod methodAt(int index) {
        assert (index == 0);
        return this.concrete;
    }

    @Override
    public double probabilityAt(int index) {
        assert (index == 0);
        return 1.0;
    }

    @Override
    public double relevanceAt(int index) {
        assert (index == 0);
        return 1.0;
    }

    public String toString() {
        return "exact " + this.concrete.format("%H.%n(%p):%r");
    }

    @Override
    public Inlineable inlineableElementAt(int index) {
        assert (index == 0);
        return this.inlineableElement;
    }

    @Override
    public void setInlinableElement(int index, Inlineable inlineableElement) {
        assert (index == 0);
        this.inlineableElement = inlineableElement;
    }

    @Override
    public boolean shouldInline() {
        return this.concrete.shouldBeInlined();
    }
}

