/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common.inlining.info;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.common.inlining.info.AbstractInlineInfo;
import org.graalvm.compiler.phases.common.inlining.info.elem.Inlineable;
import org.graalvm.compiler.phases.util.Providers;

public class TypeGuardInlineInfo
extends AbstractInlineInfo {
    private final ResolvedJavaMethod concrete;
    private final ResolvedJavaType type;
    private Inlineable inlineableElement;

    public TypeGuardInlineInfo(Invoke invoke, ResolvedJavaMethod concrete, ResolvedJavaType type) {
        super(invoke);
        this.concrete = concrete;
        this.type = type;
        assert (type.isArray() || type.isConcrete()) : type;
    }

    @Override
    public int numberOfMethods() {
        return 1;
    }

    @Override
    public ResolvedJavaMethod methodAt(int index) {
        assert (index == 0);
        return this.concrete;
    }

    @Override
    public Inlineable inlineableElementAt(int index) {
        assert (index == 0);
        return this.inlineableElement;
    }

    @Override
    public double probabilityAt(int index) {
        assert (index == 0);
        return 1.0;
    }

    @Override
    public double relevanceAt(int index) {
        assert (index == 0);
        return 1.0;
    }

    @Override
    public void setInlinableElement(int index, Inlineable inlineableElement) {
        assert (index == 0);
        this.inlineableElement = inlineableElement;
    }

    @Override
    public EconomicSet<Node> inline(Providers providers, String reason) {
        this.createGuard(this.graph(), providers);
        return TypeGuardInlineInfo.inline(this.invoke, this.concrete, this.inlineableElement, false, reason);
    }

    @Override
    public void tryToDevirtualizeInvoke(Providers providers) {
        this.createGuard(this.graph(), providers);
        InliningUtil.replaceInvokeCallTarget(this.invoke, this.graph(), CallTargetNode.InvokeKind.Special, this.concrete);
    }

    private void createGuard(StructuredGraph graph, Providers providers) {
        try (DebugCloseable context = this.invoke.asNode().withNodeSourcePosition();){
            ValueNode nonNullReceiver = InliningUtil.nonNullReceiver(this.invoke);
            LoadHubNode receiverHub = graph.unique(new LoadHubNode(providers.getStampProvider(), nonNullReceiver));
            ConstantNode typeHub = ConstantNode.forConstant(receiverHub.stamp(NodeView.DEFAULT), providers.getConstantReflection().asObjectHub(this.type), providers.getMetaAccess(), graph);
            LogicNode typeCheck = CompareNode.createCompareNode(graph, CanonicalCondition.EQ, receiverHub, typeHub, providers.getConstantReflection(), NodeView.DEFAULT);
            FixedGuardNode guard = graph.add(new FixedGuardNode(typeCheck, DeoptimizationReason.TypeCheckedInliningViolated, DeoptimizationAction.InvalidateReprofile));
            assert (this.invoke.predecessor() != null);
            PiNode anchoredReceiver = InliningUtil.createAnchoredReceiver(graph, guard, this.type, nonNullReceiver, true);
            this.invoke.callTarget().replaceFirstInput(nonNullReceiver, anchoredReceiver);
            graph.addBeforeFixed(this.invoke.asNode(), guard);
        }
    }

    public String toString() {
        return "type-checked with type " + this.type.getName() + " and method " + this.concrete.format("%H.%n(%p):%r");
    }

    @Override
    public boolean shouldInline() {
        return this.concrete.shouldBeInlined();
    }
}

