/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.printer;

import java.util.ArrayList;
import java.util.List;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugDumpHandler;
import org.graalvm.compiler.debug.DebugHandler;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.compiler.printer.BinaryGraphPrinter;
import org.graalvm.compiler.printer.CFGPrinterObserver;
import org.graalvm.compiler.printer.CanonicalStringGraphPrinter;
import org.graalvm.compiler.printer.GraphPrinterDumpHandler;
import org.graalvm.compiler.printer.NoDeadCodeVerifyHandler;
import org.graalvm.compiler.serviceprovider.ServiceProvider;

@ServiceProvider(value=DebugHandlersFactory.class)
public class GraalDebugHandlersFactory
implements DebugHandlersFactory {
    private final SnippetReflectionProvider snippetReflection;

    public GraalDebugHandlersFactory() {
        this.snippetReflection = null;
    }

    public GraalDebugHandlersFactory(SnippetReflectionProvider snippetReflection) {
        this.snippetReflection = snippetReflection;
    }

    @Override
    public List<DebugHandler> createHandlers(OptionValues options) {
        ArrayList<DebugHandler> handlers = new ArrayList<DebugHandler>();
        handlers.add(new GraphPrinterDumpHandler((debug, graph) -> new BinaryGraphPrinter(debug, this.snippetReflection)));
        if (DebugOptions.PrintCanonicalGraphStrings.getValue(options).booleanValue()) {
            handlers.add(new GraphPrinterDumpHandler((debug, graph) -> GraalDebugHandlersFactory.createStringPrinter(this.snippetReflection)));
        }
        handlers.add(new NodeDumper());
        if (DebugOptions.PrintCFG.getValue(options).booleanValue() || DebugOptions.PrintBackendCFG.getValue(options).booleanValue()) {
            handlers.add(new CFGPrinterObserver());
        }
        handlers.add(new NoDeadCodeVerifyHandler());
        return handlers;
    }

    private static CanonicalStringGraphPrinter createStringPrinter(SnippetReflectionProvider snippetReflection) {
        return new CanonicalStringGraphPrinter(snippetReflection);
    }

    static StructuredGraph.ScheduleResult tryGetSchedule(DebugContext debug, StructuredGraph graph) {
        StructuredGraph.ScheduleResult scheduleResult = graph.getLastSchedule();
        if (scheduleResult == null && (DebugOptions.PrintGraphWithSchedule.getValue(graph.getOptions()).booleanValue() || debug.contextLookup(Throwable.class) != null)) {
            try (DebugCloseable noIntercept = debug.disableIntercept();){
                SchedulePhase schedule = new SchedulePhase(graph.getOptions());
                schedule.apply(graph);
                scheduleResult = graph.getLastSchedule();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return scheduleResult;
    }

    private static class NodeDumper
    implements DebugDumpHandler {
        private NodeDumper() {
        }

        @Override
        public void dump(DebugContext debug, Object object, String format, Object ... arguments) {
            if (object instanceof Node) {
                Node node = (Node)object;
                String location = GraphUtil.approxSourceLocation(node);
                String nodeName = node.toString(Verbosity.Debugger);
                if (location != null) {
                    debug.log("Context obj %s (approx. location: %s)", (Object)nodeName, (Object)location);
                } else {
                    debug.log("Context obj %s", (Object)nodeName);
                }
            }
        }
    }
}

