/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.util.EnumMap;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.extended.UnboxNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public class BoxingSnippets
implements Snippets {
    @Snippet
    public static Object booleanValueOf(boolean value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(value);
    }

    @Snippet
    public static Object byteValueOf(byte value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(value);
    }

    @Snippet
    public static Object charValueOf(char value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(Character.valueOf(value));
    }

    @Snippet
    public static Object doubleValueOf(double value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(value);
    }

    @Snippet
    public static Object floatValueOf(float value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(Float.valueOf(value));
    }

    @Snippet
    public static Object intValueOf(int value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(value);
    }

    @Snippet
    public static Object longValueOf(long value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(value);
    }

    @Snippet
    public static Object shortValueOf(short value, @Snippet.ConstantParameter SnippetCounter valueOfCounter) {
        valueOfCounter.inc();
        return PiNode.piCastToSnippetReplaceeStamp(value);
    }

    @Snippet
    public static boolean booleanValue(Boolean value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value;
    }

    @Snippet
    public static byte byteValue(Byte value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value;
    }

    @Snippet
    public static char charValue(Character value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value.charValue();
    }

    @Snippet
    public static double doubleValue(Double value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value;
    }

    @Snippet
    public static float floatValue(Float value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value.floatValue();
    }

    @Snippet
    public static int intValue(Integer value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value;
    }

    @Snippet
    public static long longValue(Long value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value;
    }

    @Snippet
    public static short shortValue(Short value, @Snippet.ConstantParameter SnippetCounter valueCounter) {
        valueCounter.inc();
        return value;
    }

    public static FloatingNode canonicalizeBoxing(BoxNode box, MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection) {
        ValueNode value = box.getValue();
        if (value.isConstant()) {
            JavaConstant boxedConstant;
            JavaConstant sourceConstant = value.asJavaConstant();
            if (sourceConstant.getJavaKind() != box.getBoxingKind() && sourceConstant.getJavaKind().isNumericInteger()) {
                switch (box.getBoxingKind()) {
                    case Boolean: {
                        sourceConstant = JavaConstant.forBoolean((sourceConstant.asLong() != 0L ? 1 : 0) != 0);
                        break;
                    }
                    case Byte: {
                        sourceConstant = JavaConstant.forByte((byte)((byte)sourceConstant.asLong()));
                        break;
                    }
                    case Char: {
                        sourceConstant = JavaConstant.forChar((char)((char)sourceConstant.asLong()));
                        break;
                    }
                    case Short: {
                        sourceConstant = JavaConstant.forShort((short)((short)sourceConstant.asLong()));
                    }
                }
            }
            if ((boxedConstant = constantReflection.boxPrimitive(sourceConstant)) != null && sourceConstant.getJavaKind() == box.getBoxingKind()) {
                return ConstantNode.forConstant(boxedConstant, metaAccess, box.graph());
            }
        }
        return null;
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final EnumMap<JavaKind, SnippetTemplate.SnippetInfo> boxSnippets = new EnumMap(JavaKind.class);
        private final EnumMap<JavaKind, SnippetTemplate.SnippetInfo> unboxSnippets = new EnumMap(JavaKind.class);
        private final SnippetCounter valueOfCounter;
        private final SnippetCounter valueCounter;

        public Templates(OptionValues options, Iterable<DebugHandlersFactory> factories, SnippetCounter.Group.Factory factory, Providers providers, SnippetReflectionProvider snippetReflection, TargetDescription target) {
            super(options, factories, providers, snippetReflection, target);
            for (JavaKind kind : new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Double, JavaKind.Float, JavaKind.Int, JavaKind.Long, JavaKind.Short}) {
                this.boxSnippets.put(kind, this.snippet(BoxingSnippets.class, kind.getJavaName() + "ValueOf", new LocationIdentity[0]));
                this.unboxSnippets.put(kind, this.snippet(BoxingSnippets.class, kind.getJavaName() + "Value", new LocationIdentity[0]));
            }
            SnippetCounter.Group group = factory.createSnippetCounterGroup("Boxing");
            this.valueOfCounter = new SnippetCounter(group, "valueOf", "box intrinsification");
            this.valueCounter = new SnippetCounter(group, "<kind>Value", "unbox intrinsification");
        }

        public void lower(BoxNode box, LoweringTool tool) {
            FloatingNode canonical = BoxingSnippets.canonicalizeBoxing(box, this.providers.getMetaAccess(), this.providers.getConstantReflection());
            if (canonical != null && !GraalOptions.ImmutableCode.getValue(box.getOptions()).booleanValue()) {
                box.graph().replaceFixedWithFloating(box, canonical);
            } else {
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.boxSnippets.get(box.getBoxingKind()), box.graph().getGuardsStage(), tool.getLoweringStage());
                args.add("value", box.getValue());
                args.addConst("valueOfCounter", this.valueOfCounter);
                SnippetTemplate template = this.template(box, args);
                box.getDebug().log("Lowering integerValueOf in %s: node=%s, template=%s, arguments=%s", box.graph(), (Object)box, (Object)template, (Object)args);
                template.instantiate(this.providers.getMetaAccess(), box, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        public void lower(UnboxNode unbox, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.unboxSnippets.get(unbox.getBoxingKind()), unbox.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("value", unbox.getValue());
            args.addConst("valueCounter", this.valueCounter);
            SnippetTemplate template = this.template(unbox, args);
            unbox.getDebug().log("Lowering integerValueOf in %s: node=%s, template=%s, arguments=%s", unbox.graph(), (Object)unbox, (Object)template, (Object)args);
            template.instantiate(this.providers.getMetaAccess(), unbox, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

