/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graalvm.compiler.replacements.SnippetCounterNode;

public final class SnippetCounter
implements Comparable<SnippetCounter> {
    public static final SnippetCounter DISABLED_COUNTER = new SnippetCounter(null, "Disabled", "Disabled");
    private final Group group;
    private final String name;
    private final String description;
    private long value;

    @Override
    public int compareTo(SnippetCounter o) {
        return Long.signum(o.value - this.value);
    }

    public SnippetCounter(Group group, String name, String description) {
        this.group = group;
        this.name = name;
        this.description = description;
        if (group != null) {
            List<SnippetCounter> counters = group.counters;
            counters.add(this);
        }
    }

    public Group getGroup() {
        return this.group;
    }

    public void inc() {
        if (this.getGroup() != null) {
            SnippetCounterNode.increment(this);
        }
    }

    public void add(int increment) {
        if (this.getGroup() != null) {
            SnippetCounterNode.add(this, increment);
        }
    }

    public long value() {
        return this.value;
    }

    public String toString() {
        if (this.group != null) {
            return "SnippetCounter-" + this.group.name + ":" + this.name;
        }
        return super.toString();
    }

    public static class Group {
        public static final Factory NullFactory = new Factory(){

            @Override
            public Group createSnippetCounterGroup(String name) {
                return null;
            }
        };
        final String name;
        final List<SnippetCounter> counters;

        public Group(String name) {
            this.name = name;
            this.counters = new ArrayList<SnippetCounter>();
        }

        public synchronized String toString() {
            Collections.sort(this.counters);
            long total = 0L;
            int maxNameLen = 0;
            for (SnippetCounter c : this.counters) {
                total += c.value;
                maxNameLen = Math.max(c.name.length(), maxNameLen);
            }
            StringBuilder buf = new StringBuilder(String.format("Counters: %s%n", this.name));
            String formatString = "  %" + maxNameLen + "s: %6.2f%%%," + (String.format("%,d", total).length() + 2) + "d  // %s%n";
            for (SnippetCounter c : this.counters) {
                double percent = (double)total == 0.0 ? 0.0 : (double)(c.value * 100L) / (double)total;
                buf.append(String.format(formatString, c.name, percent, c.value, c.description));
            }
            buf.append(String.format(formatString, "TOTAL", 100.0, total, ""));
            return buf.toString();
        }

        public static interface Factory {
            public Group createSnippetCounterGroup(String var1);
        }
    }
}

