/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.replacements.ReplacementsUtil;

@ClassSubstitution(className={"java.lang.StringUTF16"}, optional=true)
public class StringUTF16Substitutions {
    @MethodSubstitution
    public static char getChar(byte[] value, int i) {
        ReplacementsUtil.runtimeAssert((i << 1) + 1 < value.length, "Trusted caller missed bounds check");
        return StringUTF16Substitutions.getCharDirect(value, i << 1);
    }

    public static native char getCharDirect(byte[] var0, int var1);

    @MethodSubstitution
    public static void putChar(byte[] value, int i, int c) {
        ReplacementsUtil.runtimeAssert((i << 1) + 1 < value.length, "Trusted caller missed bounds check");
        StringUTF16Substitutions.putCharDirect(value, i << 1, c);
    }

    public static native void putCharDirect(byte[] var0, int var1, int var2);
}

