/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(size=NodeSize.SIZE_512, cycles=NodeCycles.CYCLES_UNKNOWN)
public class AMD64ArrayIndexOfDispatchNode
extends FixedWithNextNode
implements Lowerable,
MemoryAccess,
DeoptimizingNode.DeoptBefore {
    public static final NodeClass<AMD64ArrayIndexOfDispatchNode> TYPE = NodeClass.create(AMD64ArrayIndexOfDispatchNode.class);
    private final ForeignCallDescriptor stubCallDescriptor;
    private final JavaKind arrayKind;
    private final JavaKind valueKind;
    private final boolean findTwoConsecutive;
    @Node.Input
    private ValueNode arrayPointer;
    @Node.Input
    private ValueNode arrayLength;
    @Node.Input
    private ValueNode fromIndex;
    @Node.Input
    private NodeInputList<ValueNode> searchValues;
    @Node.OptionalInput(value=InputType.Memory)
    private MemoryNode lastLocationAccess;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateBefore;

    public AMD64ArrayIndexOfDispatchNode(@Node.ConstantNodeParameter ForeignCallDescriptor stubCallDescriptor, @Node.ConstantNodeParameter JavaKind arrayKind, @Node.ConstantNodeParameter JavaKind valueKind, @Node.ConstantNodeParameter boolean findTwoConsecutive, ValueNode arrayPointer, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(JavaKind.Int));
        this.stubCallDescriptor = stubCallDescriptor;
        this.arrayKind = arrayKind;
        this.valueKind = valueKind;
        this.findTwoConsecutive = findTwoConsecutive;
        this.arrayPointer = arrayPointer;
        this.arrayLength = arrayLength;
        this.fromIndex = fromIndex;
        this.searchValues = new NodeInputList((Node)this, (Node[])searchValues);
    }

    public boolean isFindTwoConsecutive() {
        return this.findTwoConsecutive;
    }

    public ValueNode getArrayPointer() {
        return this.arrayPointer;
    }

    public ValueNode getArrayLength() {
        return this.arrayLength;
    }

    public ValueNode getFromIndex() {
        return this.fromIndex;
    }

    public NodeInputList<ValueNode> getSearchValues() {
        return this.searchValues;
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public void setStateBefore(FrameState f) {
        this.updateUsages(this.stateBefore, f);
        this.stateBefore = f;
    }

    @Override
    public FrameState stateBefore() {
        return this.stateBefore;
    }

    public ForeignCallDescriptor getStubCallDescriptor() {
        return this.stubCallDescriptor;
    }

    public int getNumberOfValues() {
        return this.searchValues.size();
    }

    public JavaKind getArrayKind() {
        return this.arrayKind;
    }

    public JavaKind getValueKind() {
        return this.valueKind;
    }

    public JavaKind getComparisonKind() {
        return this.findTwoConsecutive ? (this.valueKind == JavaKind.Byte ? JavaKind.Char : JavaKind.Int) : this.valueKind;
    }

    public ValueNode[] getStubCallArgs() {
        ValueNode[] ret = new ValueNode[this.searchValues.size() + 3];
        ret[0] = this.arrayPointer;
        ret[1] = this.arrayLength;
        ret[2] = this.fromIndex;
        for (int i = 0; i < this.searchValues.size(); ++i) {
            ret[3 + i] = (ValueNode)this.searchValues.get(i);
        }
        return ret;
    }

    public AMD64ArrayIndexOfDispatchNode(@Node.ConstantNodeParameter ForeignCallDescriptor stubCallDescriptor, @Node.ConstantNodeParameter JavaKind arrayKind, @Node.ConstantNodeParameter JavaKind valueKind, ValueNode arrayPointer, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        this(stubCallDescriptor, arrayKind, valueKind, false, arrayPointer, arrayLength, fromIndex, searchValues);
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return NamedLocationIdentity.getArrayLocation(this.arrayKind);
    }

    @Override
    public void lower(LoweringTool tool) {
        tool.getLowerer().lower(this, tool);
    }

    @Override
    public MemoryNode getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryNode lla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lastLocationAccess), ValueNodeUtil.asNode(lla));
        this.lastLocationAccess = lla;
    }

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter ForeignCallDescriptor var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter boolean var3, Object var4, int var5, int var6, byte var7);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter ForeignCallDescriptor var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter boolean var3, Object var4, int var5, int var6, byte var7, byte var8);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter ForeignCallDescriptor var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter boolean var3, Object var4, int var5, int var6, byte var7, byte var8, byte var9);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter ForeignCallDescriptor var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter boolean var3, Object var4, int var5, int var6, byte var7, byte var8, byte var9, byte var10);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter ForeignCallDescriptor var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter boolean var3, Object var4, int var5, int var6, char var7);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter ForeignCallDescriptor var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter boolean var3, Object var4, int var5, int var6, char var7, char var8);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter ForeignCallDescriptor var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter boolean var3, Object var4, int var5, int var6, char var7, char var8, char var9);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter ForeignCallDescriptor var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter boolean var3, Object var4, int var5, int var6, char var7, char var8, char var9, char var10);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter ForeignCallDescriptor var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter JavaKind var2, @Node.ConstantNodeParameter boolean var3, Object var4, int var5, int var6, int var7);

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallDescriptor descriptor, byte[] array, int arrayLength, int fromIndex, byte v1) {
        return AMD64ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Byte, false, (Object)array, arrayLength, fromIndex, v1);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallDescriptor descriptor, byte[] array, int arrayLength, int fromIndex, byte v1, byte v2) {
        return AMD64ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Byte, false, (Object)array, arrayLength, fromIndex, v1, v2);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallDescriptor descriptor, byte[] array, int arrayLength, int fromIndex, byte v1, byte v2, byte v3) {
        return AMD64ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Byte, false, (Object)array, arrayLength, fromIndex, v1, v2, v3);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallDescriptor descriptor, byte[] array, int arrayLength, int fromIndex, byte v1, byte v2, byte v3, byte v4) {
        return AMD64ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Byte, false, (Object)array, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallDescriptor descriptor, byte[] array, int arrayLength, int fromIndex, char v1) {
        return AMD64ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallDescriptor descriptor, byte[] array, int arrayLength, int fromIndex, char v1, char v2) {
        return AMD64ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1, v2);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallDescriptor descriptor, byte[] array, int arrayLength, int fromIndex, char v1, char v2, char v3) {
        return AMD64ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1, v2, v3);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallDescriptor descriptor, byte[] array, int arrayLength, int fromIndex, char v1, char v2, char v3, char v4) {
        return AMD64ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallDescriptor descriptor, char[] array, int arrayLength, int fromIndex, char v1) {
        return AMD64ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Char, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallDescriptor descriptor, char[] array, int arrayLength, int fromIndex, char v1, char v2) {
        return AMD64ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Char, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1, v2);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallDescriptor descriptor, char[] array, int arrayLength, int fromIndex, char v1, char v2, char v3) {
        return AMD64ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Char, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1, v2, v3);
    }

    public static int indexOf(@Node.ConstantNodeParameter ForeignCallDescriptor descriptor, char[] array, int arrayLength, int fromIndex, char v1, char v2, char v3, char v4) {
        return AMD64ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Char, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    public static int indexOf2ConsecutiveBytes(@Node.ConstantNodeParameter ForeignCallDescriptor descriptor, byte[] array, int arrayLength, int fromIndex, int values) {
        return AMD64ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Byte, true, (Object)array, arrayLength, fromIndex, values);
    }

    public static int indexOf2ConsecutiveChars(@Node.ConstantNodeParameter ForeignCallDescriptor descriptor, byte[] array, int arrayLength, int fromIndex, int values) {
        return AMD64ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Byte, JavaKind.Char, true, (Object)array, arrayLength, fromIndex, values);
    }

    public static int indexOf2ConsecutiveChars(@Node.ConstantNodeParameter ForeignCallDescriptor descriptor, char[] array, int arrayLength, int fromIndex, int values) {
        return AMD64ArrayIndexOfDispatchNode.optimizedArrayIndexOf(descriptor, JavaKind.Char, JavaKind.Char, true, (Object)array, arrayLength, fromIndex, values);
    }
}

