/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.arraycopy;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.nodes.BasicArrayCopyNode;

@NodeInfo(allowedUsageTypes={InputType.Memory})
public final class ArrayCopyWithDelayedLoweringNode
extends BasicArrayCopyNode {
    public static final NodeClass<ArrayCopyWithDelayedLoweringNode> TYPE = NodeClass.create(ArrayCopyWithDelayedLoweringNode.class);
    private final SnippetTemplate.SnippetInfo snippet;

    public ArrayCopyWithDelayedLoweringNode(ValueNode src, ValueNode srcPos, ValueNode dest, ValueNode destPos, ValueNode length, SnippetTemplate.SnippetInfo snippet, JavaKind elementKind) {
        super(TYPE, src, srcPos, dest, destPos, length, elementKind, -6);
        assert (StampTool.isPointerNonNull(src) && StampTool.isPointerNonNull(dest)) : "must have been null checked";
        this.snippet = snippet;
    }

    @Node.NodeIntrinsic
    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4, @Node.ConstantNodeParameter SnippetTemplate.SnippetInfo var5, @Node.ConstantNodeParameter JavaKind var6);

    public SnippetTemplate.SnippetInfo getSnippet() {
        return this.snippet;
    }

    public void setBci(int bci) {
        this.bci = bci;
    }
}

