/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.replacements.classfile.Classfile;
import org.graalvm.compiler.replacements.classfile.ClassfileBytecodeProvider;
import org.graalvm.compiler.replacements.classfile.ClassfileConstant;

class ClassfileConstantPool
implements ConstantPool {
    final ClassfileConstant[] entries;
    final ClassfileBytecodeProvider context;

    ClassfileConstantPool(DataInputStream stream, ClassfileBytecodeProvider context) throws IOException {
        this.context = context;
        int count = stream.readUnsignedShort();
        this.entries = new ClassfileConstant[count];
        int i = 1;
        while (i < count) {
            this.entries[i] = ClassfileConstantPool.readConstant(stream);
            byte tag = this.entries[i].tag;
            if (tag == 6 || tag == 5) {
                i += 2;
                continue;
            }
            ++i;
        }
    }

    static final ClassfileConstant readConstant(DataInputStream stream) throws IOException {
        byte tag = stream.readByte();
        switch (tag) {
            case 7: {
                return new ClassfileConstant.ClassRef(stream);
            }
            case 9: {
                return new ClassfileConstant.FieldRef(stream);
            }
            case 10: {
                return new ClassfileConstant.MethodRef(stream);
            }
            case 11: {
                return new ClassfileConstant.InterfaceMethodRef(stream);
            }
            case 8: {
                return new ClassfileConstant.StringRef(stream);
            }
            case 3: {
                return new ClassfileConstant.Primitive(tag, (JavaConstant)JavaConstant.forInt((int)stream.readInt()));
            }
            case 4: {
                return new ClassfileConstant.Primitive(tag, (JavaConstant)JavaConstant.forFloat((float)stream.readFloat()));
            }
            case 5: {
                return new ClassfileConstant.Primitive(tag, (JavaConstant)JavaConstant.forLong((long)stream.readLong()));
            }
            case 6: {
                return new ClassfileConstant.Primitive(tag, (JavaConstant)JavaConstant.forDouble((double)stream.readDouble()));
            }
            case 12: {
                return new ClassfileConstant.NameAndType(stream);
            }
            case 1: {
                return new ClassfileConstant.Utf8(stream.readUTF());
            }
            case 15: {
                Classfile.skipFully(stream, 3);
                return new ClassfileConstant.Unsupported(tag, "CONSTANT_MethodHandle_info");
            }
            case 16: {
                Classfile.skipFully(stream, 2);
                return new ClassfileConstant.Unsupported(tag, "CONSTANT_MethodType_info");
            }
            case 17: {
                Classfile.skipFully(stream, 4);
                return new ClassfileConstant.Unsupported(tag, "CONSTANT_Dynamic_info");
            }
            case 18: {
                Classfile.skipFully(stream, 4);
                return new ClassfileConstant.Unsupported(tag, "CONSTANT_InvokeDynamic_info");
            }
        }
        throw new GraalError("Invalid constant pool tag: " + tag);
    }

    public int length() {
        return this.entries.length;
    }

    <T extends ClassfileConstant> T get(Class<T> c, int index) {
        return (T)((ClassfileConstant)c.cast(this.entries[index]));
    }

    public void loadReferencedType(int index, int opcode) {
        if (opcode == 186) {
            throw new GraalError("INVOKEDYNAMIC not supported by " + ClassfileBytecodeProvider.class.getSimpleName());
        }
        this.entries[index].loadReferencedType(this, index, opcode);
    }

    public JavaField lookupField(int index, ResolvedJavaMethod method, int opcode) {
        return this.get(ClassfileConstant.FieldRef.class, index).resolve(this, opcode);
    }

    public JavaMethod lookupMethod(int index, int opcode) {
        if (opcode == 186) {
            throw new GraalError("INVOKEDYNAMIC not supported by" + ClassfileBytecodeProvider.class.getSimpleName());
        }
        return this.get(ClassfileConstant.ExecutableRef.class, index).resolve(this, opcode);
    }

    public JavaType lookupType(int index, int opcode) {
        return this.get(ClassfileConstant.ClassRef.class, index).resolve(this);
    }

    public String lookupUtf8(int index) {
        return ((ClassfileConstant.Utf8)this.entries[index]).value;
    }

    public Signature lookupSignature(int index) {
        throw GraalError.shouldNotReachHere();
    }

    public Object lookupConstant(int index) {
        ClassfileConstant c = this.entries[index];
        if (c instanceof ClassfileConstant.Primitive) {
            ClassfileConstant.Primitive p = (ClassfileConstant.Primitive)c;
            return p.value;
        }
        switch (c.tag) {
            case 7: {
                int opcode = -1;
                return this.lookupType(index, -1);
            }
            case 8: {
                return ((ClassfileConstant.StringRef)c).getValue(this);
            }
        }
        throw new GraalError("Unexpected constant pool tag %s", c.tag);
    }

    public JavaConstant lookupAppendix(int index, int opcode) {
        if (opcode == 182) {
            return null;
        }
        throw GraalError.shouldNotReachHere();
    }

    public static class Bytecodes {
        public static final int GETSTATIC = 178;
        public static final int PUTSTATIC = 179;
        public static final int GETFIELD = 180;
        public static final int PUTFIELD = 181;
        public static final int INVOKEVIRTUAL = 182;
        public static final int INVOKESPECIAL = 183;
        public static final int INVOKESTATIC = 184;
        public static final int INVOKEINTERFACE = 185;
        public static final int INVOKEDYNAMIC = 186;
    }
}

