/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryNode;
import org.graalvm.compiler.nodes.calc.FloatDivNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.nodes.calc.SqrtNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(nameTemplate="MathIntrinsic#{p#operation/s}", cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_1)
public final class BinaryMathIntrinsicNode
extends BinaryNode
implements ArithmeticLIRLowerable,
Lowerable {
    public static final NodeClass<BinaryMathIntrinsicNode> TYPE = NodeClass.create(BinaryMathIntrinsicNode.class);
    protected final BinaryOperation operation;

    public BinaryOperation getOperation() {
        return this.operation;
    }

    public static ValueNode create(ValueNode forX, ValueNode forY, BinaryOperation op) {
        ValueNode c = BinaryMathIntrinsicNode.tryConstantFold(forX, forY, op);
        if (c != null) {
            return c;
        }
        return new BinaryMathIntrinsicNode(forX, forY, op);
    }

    protected static ValueNode tryConstantFold(ValueNode forX, ValueNode forY, BinaryOperation op) {
        if (forX.isConstant() && forY.isConstant()) {
            double ret = BinaryMathIntrinsicNode.doCompute(forX.asJavaConstant().asDouble(), forY.asJavaConstant().asDouble(), op);
            return ConstantNode.forDouble(ret);
        }
        return null;
    }

    @Override
    public Stamp foldStamp(Stamp stampX, Stamp stampY) {
        return this.stamp(NodeView.DEFAULT);
    }

    protected BinaryMathIntrinsicNode(ValueNode forX, ValueNode forY, BinaryOperation op) {
        super(TYPE, StampFactory.forKind(JavaKind.Double), forX, forY);
        assert (forX.stamp(NodeView.DEFAULT) instanceof FloatStamp && PrimitiveStamp.getBits(forX.stamp(NodeView.DEFAULT)) == 64);
        assert (forY.stamp(NodeView.DEFAULT) instanceof FloatStamp && PrimitiveStamp.getBits(forY.stamp(NodeView.DEFAULT)) == 64);
        this.operation = op;
    }

    @Override
    public void lower(LoweringTool tool) {
        tool.getLowerer().lower(this, tool);
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        Value result;
        Value xValue = nodeValueMap.operand(this.getX());
        Value yValue = nodeValueMap.operand(this.getY());
        switch (this.getOperation()) {
            case POW: {
                result = gen.emitMathPow(xValue, yValue);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        nodeValueMap.setResult(this, result);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        ValueNode c = BinaryMathIntrinsicNode.tryConstantFold(forX, forY, this.getOperation());
        if (c != null) {
            return c;
        }
        if (forY.isConstant()) {
            double yValue = forY.asJavaConstant().asDouble();
            if (yValue == 0.0) {
                return ConstantNode.forDouble(1.0);
            }
            if (yValue == 1.0) {
                return this.x;
            }
            if (Double.isNaN(yValue)) {
                return ConstantNode.forDouble(Double.NaN);
            }
            if (yValue == -1.0) {
                return new FloatDivNode(ConstantNode.forDouble(1.0), this.x);
            }
            if (yValue == 2.0) {
                return new MulNode(this.x, this.x);
            }
            if (yValue == 0.5 && this.x.stamp(view) instanceof FloatStamp && ((FloatStamp)this.x.stamp(view)).lowerBound() >= 0.0) {
                return SqrtNode.create(this.x, view);
            }
        }
        return this;
    }

    @Node.NodeIntrinsic
    public static native double compute(double var0, double var2, @Node.ConstantNodeParameter BinaryOperation var4);

    private static double doCompute(double x, double y, BinaryOperation op) {
        switch (op) {
            case POW: {
                return Math.pow(x, y);
            }
        }
        throw new GraalError("unknown op %s", new Object[]{op});
    }

    public static enum BinaryOperation {
        POW(new ForeignCallDescriptor("arithmeticPow", Double.TYPE, Double.TYPE, Double.TYPE));

        public final ForeignCallDescriptor foreignCallDescriptor;

        private BinaryOperation(ForeignCallDescriptor foreignCallDescriptor) {
            this.foreignCallDescriptor = foreignCallDescriptor;
        }
    }
}

