/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.type.DataPointerConstant;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.word.Word;

public final class CStringConstant
extends DataPointerConstant {
    private static final Charset UTF8 = Charset.forName("utf8");
    private final String string;

    public CStringConstant(String string) {
        super(1);
        assert (string != null);
        this.string = string;
    }

    public int getSerializedSize() {
        return this.string.getBytes(UTF8).length + 1;
    }

    public void serialize(ByteBuffer buffer) {
        byte[] bytes = this.string.getBytes(UTF8);
        buffer.put(bytes);
        buffer.put((byte)0);
    }

    public String toValueString() {
        return "c\"" + this.string + "\"";
    }

    public static boolean intrinsify(GraphBuilderContext b, ResolvedJavaMethod targetMethod, String string) {
        b.addPush(JavaKind.Object, new ConstantNode((Constant)new CStringConstant(string), StampFactory.pointer()));
        return true;
    }

    @Node.NodeIntrinsic
    public static native Word cstring(@Node.ConstantNodeParameter String var0);
}

