/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes.arithmetic;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.nodes.extended.GuardedNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticNode;

@NodeInfo(cycles=NodeCycles.CYCLES_4, cyclesRationale="mul+cmp", size=NodeSize.SIZE_2)
public final class IntegerMulExactNode
extends MulNode
implements GuardedNode,
IntegerExactArithmeticNode {
    public static final NodeClass<IntegerMulExactNode> TYPE = NodeClass.create(IntegerMulExactNode.class);
    @Node.Input(value=InputType.Guard)
    protected GuardingNode guard;

    public IntegerMulExactNode(ValueNode x, ValueNode y, GuardingNode guard) {
        super(TYPE, x, y);
        this.setStamp(x.stamp(NodeView.DEFAULT).unrestricted());
        assert (x.stamp(NodeView.DEFAULT).isCompatible(y.stamp(NodeView.DEFAULT)) && x.stamp(NodeView.DEFAULT) instanceof IntegerStamp);
        this.guard = guard;
    }

    @Override
    public boolean inferStamp() {
        return false;
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        if (forX.isConstant() && !forY.isConstant()) {
            return (ValueNode)new IntegerMulExactNode(forY, forX, this.guard).canonical(tool);
        }
        if (forX.isConstant() && forY.isConstant()) {
            return this.canonicalXYconstant(forX, forY);
        }
        if (forY.isConstant()) {
            long c = forY.asJavaConstant().asLong();
            if (c == 1L) {
                return forX;
            }
            if (c == 0L) {
                return ConstantNode.forIntegerStamp(this.stamp(NodeView.DEFAULT), 0L);
            }
        }
        if (!IntegerStamp.multiplicationCanOverflow((IntegerStamp)this.x.stamp(NodeView.DEFAULT), (IntegerStamp)this.y.stamp(NodeView.DEFAULT))) {
            return (ValueNode)new MulNode(this.x, this.y).canonical(tool);
        }
        return this;
    }

    private ValueNode canonicalXYconstant(ValueNode forX, ValueNode forY) {
        JavaConstant xConst = forX.asJavaConstant();
        JavaConstant yConst = forY.asJavaConstant();
        assert (xConst.getJavaKind() == yConst.getJavaKind());
        try {
            if (xConst.getJavaKind() == JavaKind.Int) {
                return ConstantNode.forInt(Math.multiplyExact(xConst.asInt(), yConst.asInt()));
            }
            assert (xConst.getJavaKind() == JavaKind.Long);
            return ConstantNode.forLong(Math.multiplyExact(xConst.asLong(), yConst.asLong()));
        }
        catch (ArithmeticException arithmeticException) {
            return this;
        }
    }

    @Override
    public GuardingNode getGuard() {
        return this.guard;
    }

    @Override
    public void setGuard(GuardingNode guard) {
        this.updateUsagesInterface(this.guard, guard);
        this.guard = guard;
    }
}

