/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.serviceprovider;

import com.sun.management.ThreadMXBean;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import jdk.vm.ci.code.VirtualObject;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.serviceprovider.SpeculationEncodingAdapter;

public final class GraalServices {
    private static final ClassLoader JVMCI_LOADER = GraalServices.class.getClassLoader();
    private static final ClassLoader JVMCI_PARENT_LOADER;
    private static final AtomicLong globalTimeStamp;

    private GraalServices() {
    }

    public static <S> Iterable<S> load(Class<S> service) {
        assert (!service.getName().startsWith("jdk.vm.ci")) : "JVMCI services must be loaded via " + Services.class.getName();
        return Services.load(service);
    }

    public static <S> S loadSingle(Class<S> service, boolean required) {
        assert (!service.getName().startsWith("jdk.vm.ci")) : "JVMCI services must be loaded via " + Services.class.getName();
        Iterable<S> providers = GraalServices.load(service);
        Object singleProvider = null;
        try {
            Iterator<S> it = providers.iterator();
            while (it.hasNext()) {
                singleProvider = it.next();
                if (!it.hasNext()) continue;
                S other = it.next();
                throw new InternalError(String.format("Multiple %s providers found: %s, %s", service.getName(), singleProvider.getClass().getName(), other.getClass().getName()));
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            // empty catch block
        }
        if (singleProvider == null && required) {
            throw new InternalError(String.format("No provider for %s found", service.getName()));
        }
        return (S)singleProvider;
    }

    public static InputStream getClassfileAsStream(Class<?> c) throws IOException {
        String classfilePath = c.getName().replace('.', '/') + ".class";
        ClassLoader cl = c.getClassLoader();
        if (cl == null) {
            return ClassLoader.getSystemResourceAsStream(classfilePath);
        }
        return cl.getResourceAsStream(classfilePath);
    }

    public static boolean isToStringTrusted(Class<?> c) {
        ClassLoader cl = c.getClassLoader();
        return cl == null || cl == JVMCI_LOADER || cl == JVMCI_PARENT_LOADER;
    }

    static SpeculationLog.SpeculationReason createSpeculationReason(int groupId, String groupName, Object ... context) {
        SpeculationEncodingAdapter adapter = new SpeculationEncodingAdapter();
        return new EncodedSpeculationReason(groupId, groupName, adapter.flatten(context));
    }

    public static String getExecutionID() {
        try {
            if (Lazy.runtimeMXBean == null) {
                return String.valueOf(GraalServices.getGlobalTimeStamp());
            }
            String runtimeName = Lazy.runtimeMXBean.getName();
            try {
                int index = runtimeName.indexOf(64);
                if (index != -1) {
                    long pid = Long.parseLong(runtimeName.substring(0, index));
                    return Long.toString(pid);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return runtimeName;
        }
        catch (LinkageError err) {
            return String.valueOf(GraalServices.getGlobalTimeStamp());
        }
    }

    public static long getGlobalTimeStamp() {
        if (globalTimeStamp.get() == 0L) {
            globalTimeStamp.compareAndSet(0L, System.currentTimeMillis());
        }
        return globalTimeStamp.get();
    }

    public static long getThreadAllocatedBytes(long id) {
        if (Lazy.threadMXBean == null) {
            throw new UnsupportedOperationException();
        }
        return Lazy.threadMXBean.getThreadAllocatedBytes(id);
    }

    public static long getCurrentThreadAllocatedBytes() {
        return GraalServices.getThreadAllocatedBytes(Thread.currentThread().getId());
    }

    public static long getCurrentThreadCpuTime() {
        if (Lazy.threadMXBean == null) {
            throw new UnsupportedOperationException();
        }
        return Lazy.threadMXBean.getCurrentThreadCpuTime();
    }

    public static boolean isThreadAllocatedMemorySupported() {
        if (Lazy.threadMXBean == null) {
            return false;
        }
        return Lazy.threadMXBean.isThreadAllocatedMemorySupported();
    }

    public static boolean isCurrentThreadCpuTimeSupported() {
        if (Lazy.threadMXBean == null) {
            return false;
        }
        return Lazy.threadMXBean.isCurrentThreadCpuTimeSupported();
    }

    public static List<String> getInputArguments() {
        if (Lazy.runtimeMXBean == null) {
            return null;
        }
        return Lazy.runtimeMXBean.getInputArguments();
    }

    public static float fma(float a, float b, float c) {
        float result = (float)((double)a * (double)b + (double)c);
        return result;
    }

    public static double fma(double a, double b, double c) {
        if (Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(c)) {
            return Double.NaN;
        }
        boolean infiniteA = Double.isInfinite(a);
        boolean infiniteB = Double.isInfinite(b);
        boolean infiniteC = Double.isInfinite(c);
        if (infiniteA || infiniteB || infiniteC) {
            if (infiniteA && b == 0.0 || infiniteB && a == 0.0) {
                return Double.NaN;
            }
            double product = a * b;
            if (Double.isInfinite(product) && !infiniteA && !infiniteB) {
                assert (Double.isInfinite(c));
                return c;
            }
            double result = product + c;
            assert (!Double.isFinite(result));
            return result;
        }
        BigDecimal product = new BigDecimal(a).multiply(new BigDecimal(b));
        if (c == 0.0) {
            if (a == 0.0 || b == 0.0) {
                return a * b + c;
            }
            return product.doubleValue();
        }
        return product.add(new BigDecimal(c)).doubleValue();
    }

    public static VirtualObject createVirtualObject(ResolvedJavaType type, int id, boolean isAutoBox) {
        return VirtualObject.get((ResolvedJavaType)type, (int)id, (boolean)isAutoBox);
    }

    static {
        ClassLoader classLoader = JVMCI_PARENT_LOADER = JVMCI_LOADER == null ? null : JVMCI_LOADER.getParent();
        assert (JVMCI_PARENT_LOADER == null || JVMCI_PARENT_LOADER.getParent() == null);
        globalTimeStamp = new AtomicLong();
    }

    static class Lazy {
        static final ThreadMXBean threadMXBean;
        static final RuntimeMXBean runtimeMXBean;

        Lazy() {
        }

        static {
            RuntimeMXBean resultRuntime;
            ThreadMXBean resultThread;
            try {
                resultThread = (ThreadMXBean)ManagementFactory.getThreadMXBean();
                resultRuntime = ManagementFactory.getRuntimeMXBean();
            }
            catch (NoClassDefFoundError | UnsatisfiedLinkError | UnsupportedOperationException e) {
                resultThread = null;
                resultRuntime = null;
            }
            threadMXBean = resultThread;
            runtimeMXBean = resultRuntime;
        }
    }

    public static class EncodedSpeculationReason
    implements SpeculationLog.SpeculationReason {
        final int groupId;
        final String groupName;
        final Object[] context;
        private SpeculationLog.SpeculationReasonEncoding encoding;

        public EncodedSpeculationReason(int groupId, String groupName, Object[] context) {
            this.groupId = groupId;
            this.groupName = groupName;
            this.context = context;
        }

        public boolean equals(Object obj) {
            if (obj instanceof EncodedSpeculationReason) {
                if (obj instanceof EncodedSpeculationReason) {
                    EncodedSpeculationReason that = (EncodedSpeculationReason)obj;
                    return this.groupId == that.groupId && Arrays.equals(this.context, that.context);
                }
                return false;
            }
            return false;
        }

        public SpeculationLog.SpeculationReasonEncoding encode(Supplier<SpeculationLog.SpeculationReasonEncoding> encodingSupplier) {
            if (this.encoding == null) {
                this.encoding = encodingSupplier.get();
                this.encoding.addInt(this.groupId);
                for (Object o : this.context) {
                    if (o == null) {
                        this.encoding.addInt(0);
                        continue;
                    }
                    EncodedSpeculationReason.addNonNullObject(this.encoding, o);
                }
            }
            return this.encoding;
        }

        static void addNonNullObject(SpeculationLog.SpeculationReasonEncoding encoding, Object o) {
            Class<?> c = o.getClass();
            if (c == String.class) {
                encoding.addString((String)o);
            } else if (c == Byte.class) {
                encoding.addByte((int)((Byte)o).byteValue());
            } else if (c == Short.class) {
                encoding.addShort((int)((Short)o).shortValue());
            } else if (c == Character.class) {
                encoding.addShort((int)((Character)o).charValue());
            } else if (c == Integer.class) {
                encoding.addInt(((Integer)o).intValue());
            } else if (c == Long.class) {
                encoding.addLong(((Long)o).longValue());
            } else if (c == Float.class) {
                encoding.addInt(Float.floatToRawIntBits(((Float)o).floatValue()));
            } else if (c == Double.class) {
                encoding.addLong(Double.doubleToRawLongBits((Double)o));
            } else if (o instanceof Enum) {
                encoding.addInt(((Enum)o).ordinal());
            } else if (o instanceof ResolvedJavaMethod) {
                encoding.addMethod((ResolvedJavaMethod)o);
            } else if (o instanceof ResolvedJavaType) {
                encoding.addType((ResolvedJavaType)o);
            } else if (o instanceof ResolvedJavaField) {
                encoding.addField((ResolvedJavaField)o);
            } else {
                throw new IllegalArgumentException("Unsupported type for encoding: " + c.getName());
            }
        }

        public int hashCode() {
            return this.groupId + Arrays.hashCode(this.context);
        }

        public String toString() {
            return String.format("%s@%d%s", this.groupName, this.groupId, Arrays.toString(this.context));
        }
    }
}

