/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.serviceprovider;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.serviceprovider.GraalServices;

public final class SpeculationReasonGroup {
    private final int id = nextId.get();
    private final String name;
    private final Class<?>[] signature;
    private static final AtomicInteger nextId = new AtomicInteger(1);
    private static final Set<Class<?>> SUPPORTED_EXACT_TYPES = new HashSet<Class>(Arrays.asList(String.class, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, BytecodePosition.class));

    public SpeculationReasonGroup(String name, Class<?> ... signature) {
        this.name = name;
        this.signature = signature;
        for (Class<?> c : signature) {
            if (SpeculationReasonGroup.isOfSupportedType(c)) continue;
            throw new IllegalArgumentException("Unsupported speculation context type: " + c.getName());
        }
    }

    public String toString() {
        return String.format("%s{id:%d, sig=%s}", this.name, this.id, Arrays.toString(this.signature));
    }

    public SpeculationLog.SpeculationReason createSpeculationReason(Object ... context) {
        assert (this.checkSignature(context));
        return GraalServices.createSpeculationReason(this.id, this.name, context);
    }

    private static boolean isOfSupportedType(Class<?> c) {
        if (SUPPORTED_EXACT_TYPES.contains(c)) {
            return true;
        }
        if (Enum.class.isAssignableFrom(c)) {
            return true;
        }
        if (SpeculationContextObject.class.isAssignableFrom(c)) {
            return true;
        }
        return ResolvedJavaMethod.class.isAssignableFrom(c) || ResolvedJavaType.class.isAssignableFrom(c);
    }

    static Class<?> toBox(Class<?> c) {
        if (c == Integer.TYPE) {
            return Integer.class;
        }
        if (c == Long.TYPE) {
            return Long.class;
        }
        if (c == Float.TYPE) {
            return Float.class;
        }
        if (c == Double.TYPE) {
            return Double.class;
        }
        return c;
    }

    private boolean checkSignature(Object[] context) {
        assert (this.signature.length == context.length) : this.name + ": Incorrect number of context arguments. Expected " + this.signature.length + ", got " + context.length;
        for (int i = 0; i < context.length; ++i) {
            Object o = context[i];
            Class<?> c = this.signature[i];
            if (o != null) {
                if (c == ResolvedJavaMethod.class || c == ResolvedJavaType.class || SpeculationContextObject.class.isAssignableFrom(c)) {
                    c.cast(o);
                    continue;
                }
                Class<?> oClass = o.getClass();
                assert (SpeculationReasonGroup.toBox(c) == oClass) : this.name + ": Context argument " + i + " is not a " + c.getName() + " but a " + oClass.getName();
                continue;
            }
            if (c.isPrimitive() || Enum.class.isAssignableFrom(c)) {
                throw new AssertionError((Object)(this.name + ": Cannot pass null for argument " + i));
            }
        }
        return true;
    }

    public static interface SpeculationContextObject {
        public void accept(Visitor var1);

        public static interface Visitor {
            public void visitBoolean(boolean var1);

            public void visitByte(byte var1);

            public void visitChar(char var1);

            public void visitShort(short var1);

            public void visitInt(int var1);

            public void visitLong(long var1);

            public void visitFloat(float var1);

            public void visitDouble(double var1);

            public void visitObject(Object var1);
        }
    }
}

