/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.common;

import java.lang.reflect.Method;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;

public final class TruffleCompilerRuntimeInstance {
    static TruffleCompilerRuntime truffleCompilerRuntime;
    static final Object TRUFFLE_RUNTIME;

    public static synchronized void initialize(TruffleCompilerRuntime runtime) {
        if (truffleCompilerRuntime != null) {
            throw new InternalError(String.format("Cannot re-initialize %s singleton", TruffleCompilerRuntime.class.getName()));
        }
        truffleCompilerRuntime = runtime;
    }

    private static Object init() {
        try {
            Class<?> truffleClass = Class.forName("com.oracle.truffle.api.Truffle");
            Method getRuntime = truffleClass.getMethod("getRuntime", new Class[0]);
            Object truffleRuntime = getRuntime.invoke(null, new Object[0]);
            if (truffleRuntime instanceof TruffleCompilerRuntime) {
                TruffleCompilerRuntimeInstance.initialize((TruffleCompilerRuntime)truffleRuntime);
            }
            return truffleRuntime;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    static {
        TRUFFLE_RUNTIME = TruffleCompilerRuntimeInstance.init();
    }
}

