/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.common;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.compiler.truffle.common.VoidGraphStructure;
import org.graalvm.graphio.GraphOutput;

public final class TruffleOutputGroup
implements Closeable {
    public static final String GROUP_ID = "truffle.compilation.id";
    private final GraphOutput<Void, ?> output;

    private TruffleOutputGroup(TruffleDebugContext debug, CompilableTruffleAST compilable, Map<Object, Object> properties) {
        GraphOutput<Void, ?> out;
        block4: {
            String name = "Truffle::" + compilable.getName();
            out = null;
            try {
                Map<Object, Object> effectiveProperties;
                out = debug.buildOutput(GraphOutput.newBuilder(VoidGraphStructure.INSTANCE).protocolVersion(6, 1));
                if (properties != null) {
                    effectiveProperties = new HashMap<Object, Object>(properties);
                    effectiveProperties.putAll(debug.getVersionProperties());
                } else {
                    effectiveProperties = debug.getVersionProperties();
                }
                out.beginGroup(null, name, name, null, 0, effectiveProperties);
            }
            catch (Throwable e) {
                if (out == null) break block4;
                out.close();
                out = null;
            }
        }
        this.output = out;
    }

    @Override
    public void close() throws IOException {
        try {
            this.output.endGroup();
        }
        finally {
            this.output.close();
        }
    }

    public static TruffleOutputGroup open(TruffleDebugContext debug, CompilableTruffleAST compilable, Map<Object, Object> properties) {
        if (debug != null && debug.isDumpEnabled()) {
            return new TruffleOutputGroup(debug, compilable, properties);
        }
        return null;
    }
}

