/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import java.io.Closeable;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.SourceLanguagePosition;
import org.graalvm.compiler.graph.SourceLanguagePositionProvider;
import org.graalvm.compiler.java.ComputeLoopFrequenciesClosure;
import org.graalvm.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import org.graalvm.compiler.nodes.Cancellable;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.ConditionalEliminationPhase;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.CachingPEGraphDecoder;
import org.graalvm.compiler.replacements.InlineDuringParsingPlugin;
import org.graalvm.compiler.replacements.PEGraphDecoder;
import org.graalvm.compiler.replacements.ReplacementsImpl;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.serviceprovider.SpeculationReasonGroup;
import org.graalvm.compiler.truffle.common.CallNodeProvider;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.common.TruffleSourceLanguagePosition;
import org.graalvm.compiler.truffle.compiler.SharedTruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerImpl;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.TruffleConstantFieldProvider;
import org.graalvm.compiler.truffle.compiler.debug.HistogramInlineInvokePlugin;
import org.graalvm.compiler.truffle.compiler.nodes.IsInlinedNode;
import org.graalvm.compiler.truffle.compiler.nodes.TruffleAssumption;
import org.graalvm.compiler.truffle.compiler.nodes.asserts.NeverPartOfCompilationNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.AllowMaterializeNode;
import org.graalvm.compiler.truffle.compiler.phases.DeoptimizeOnExceptionPhase;
import org.graalvm.compiler.truffle.compiler.phases.InstrumentBranchesPhase;
import org.graalvm.compiler.truffle.compiler.phases.InstrumentPhase;
import org.graalvm.compiler.truffle.compiler.phases.InstrumentTruffleBoundariesPhase;
import org.graalvm.compiler.truffle.compiler.phases.VerifyFrameDoesNotEscapePhase;
import org.graalvm.compiler.truffle.compiler.phases.inlining.AgnosticInliningPhase;
import org.graalvm.compiler.truffle.compiler.substitutions.KnownTruffleTypes;
import org.graalvm.compiler.truffle.compiler.substitutions.TruffleGraphBuilderPlugins;
import org.graalvm.compiler.truffle.compiler.substitutions.TruffleInvocationPluginProvider;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapePhase;

public abstract class PartialEvaluator {
    protected final Providers providers;
    protected final Architecture architecture;
    private final CanonicalizerPhase canonicalizer;
    private final SnippetReflectionProvider snippetReflection;
    private final ResolvedJavaMethod callDirectMethod;
    protected final ResolvedJavaMethod callInlinedMethod;
    protected final ResolvedJavaMethod callInlinedAgnosticMethod;
    private final ResolvedJavaMethod callIndirectMethod;
    private final ResolvedJavaMethod callRootMethod;
    private final GraphBuilderConfiguration configForParsing;
    private final InvocationPlugins decodingInvocationPlugins;
    private final NodePlugin[] nodePlugins;
    private final KnownTruffleTypes knownTruffleTypes;
    private final ResolvedJavaMethod callBoundary;
    protected volatile InstrumentPhase.Instrumentation instrumentation;
    private static final SpeculationReasonGroup TRUFFLE_BOUNDARY_EXCEPTION_SPECULATIONS = new SpeculationReasonGroup("TruffleBoundaryWithoutException", ResolvedJavaMethod.class);

    public PartialEvaluator(Providers providers, GraphBuilderConfiguration configForRoot, SnippetReflectionProvider snippetReflection, Architecture architecture, KnownTruffleTypes knownFields) {
        this.providers = providers;
        this.architecture = architecture;
        this.canonicalizer = CanonicalizerPhase.create();
        this.snippetReflection = snippetReflection;
        this.knownTruffleTypes = knownFields;
        TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
        MetaAccessProvider metaAccess = providers.getMetaAccess();
        ResolvedJavaType type = runtime.resolveType(metaAccess, "org.graalvm.compiler.truffle.runtime.OptimizedCallTarget");
        ResolvedJavaMethod[] methods = type.getDeclaredMethods();
        this.callDirectMethod = PartialEvaluator.findRequiredMethod(type, methods, "callDirect", "(Lcom/oracle/truffle/api/nodes/Node;[Ljava/lang/Object;)Ljava/lang/Object;");
        this.callInlinedMethod = PartialEvaluator.findRequiredMethod(type, methods, "callInlined", "(Lcom/oracle/truffle/api/nodes/Node;[Ljava/lang/Object;)Ljava/lang/Object;");
        this.callInlinedAgnosticMethod = PartialEvaluator.findRequiredMethod(type, methods, "callInlinedAgnostic", "([Ljava/lang/Object;)Ljava/lang/Object;");
        this.callIndirectMethod = PartialEvaluator.findRequiredMethod(type, methods, "callIndirect", "(Lcom/oracle/truffle/api/nodes/Node;[Ljava/lang/Object;)Ljava/lang/Object;");
        this.callRootMethod = PartialEvaluator.findRequiredMethod(type, methods, "callRoot", "([Ljava/lang/Object;)Ljava/lang/Object;");
        this.callBoundary = PartialEvaluator.findRequiredMethod(type, methods, "callBoundary", "([Ljava/lang/Object;)Ljava/lang/Object;");
        this.configForParsing = this.createGraphBuilderConfig(configForRoot, true);
        this.decodingInvocationPlugins = this.createDecodingInvocationPlugins(configForRoot.getPlugins());
        this.nodePlugins = this.createNodePlugins(configForRoot.getPlugins());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InstrumentPhase.Instrumentation getInstrumentation() {
        if (this.instrumentation == null) {
            PartialEvaluator partialEvaluator = this;
            synchronized (partialEvaluator) {
                if (this.instrumentation == null) {
                    OptionValues options = TruffleCompilerOptions.getOptions();
                    long[] accessTable = new long[TruffleCompilerOptions.TruffleInstrumentationTableSize.getValue(options).intValue()];
                    this.instrumentation = new InstrumentPhase.Instrumentation(accessTable);
                }
            }
        }
        return this.instrumentation;
    }

    static ResolvedJavaMethod findRequiredMethod(ResolvedJavaType declaringClass, ResolvedJavaMethod[] methods, String name, String descriptor) {
        for (ResolvedJavaMethod method : methods) {
            if (!method.getName().equals(name) || !method.getSignature().toMethodDescriptor().equals(descriptor)) continue;
            return method;
        }
        throw new NoSuchMethodError(declaringClass.toJavaName() + "." + name + descriptor);
    }

    private static void removeIsInlinedNodes(StructuredGraph graph) {
        for (IsInlinedNode isInlinedNode : graph.getNodes(IsInlinedNode.TYPE)) {
            isInlinedNode.notInlined();
        }
    }

    public ResolvedJavaMethod getCallDirectMethod() {
        return this.callDirectMethod;
    }

    public ResolvedJavaMethod getCallBoundary() {
        return this.callBoundary;
    }

    public Providers getProviders() {
        return this.providers;
    }

    public GraphBuilderConfiguration getConfigForParsing() {
        return this.configForParsing;
    }

    public KnownTruffleTypes getKnownTruffleTypes() {
        return this.knownTruffleTypes;
    }

    public ResolvedJavaMethod[] getCompilationRootMethods() {
        return new ResolvedJavaMethod[]{this.callRootMethod, this.callInlinedMethod, this.callInlinedAgnosticMethod};
    }

    public ResolvedJavaMethod[] getNeverInlineMethods() {
        return new ResolvedJavaMethod[]{this.callDirectMethod, this.callIndirectMethod, this.callInlinedAgnosticMethod};
    }

    private StructuredGraph createGraphForPE(DebugContext debug, String name, ResolvedJavaMethod rootMethod, StructuredGraph.AllowAssumptions allowAssumptions, CompilationIdentifier compilationId, SpeculationLog log, Cancellable cancellable) {
        OptionValues options = TruffleCompilerOptions.getOptions();
        StructuredGraph.Builder builder = new StructuredGraph.Builder(options, debug, allowAssumptions).name(name).method(rootMethod).speculationLog(log).compilationId(compilationId).trackNodeSourcePosition(this.configForParsing.trackNodeSourcePosition()).cancellable(cancellable);
        builder = this.customizeStructuredGraphBuilder(builder);
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StructuredGraph createGraph(DebugContext debug, CompilableTruffleAST compilable, TruffleInliningPlan inliningPlan, StructuredGraph.AllowAssumptions allowAssumptions, CompilationIdentifier compilationId, SpeculationLog log, Cancellable cancellable) {
        try (PerformanceInformationHandler handler = PerformanceInformationHandler.install();){
            String name = compilable.toString();
            ResolvedJavaMethod rootMethod = this.rootForCallTarget(compilable);
            StructuredGraph graph = this.createGraphForPE(debug, name, rootMethod, allowAssumptions, compilationId, log, cancellable);
            try {
                DebugContext.Scope s = debug.scope((Object)"CreateGraph", graph);
                Throwable throwable = null;
                try {
                    Throwable throwable2;
                    Indent indent;
                    block46: {
                        StructuredGraph structuredGraph;
                        block47: {
                            block48: {
                                indent = debug.logAndIndent("createGraph %s", graph);
                                throwable2 = null;
                                Providers baseContext = this.providers;
                                HighTierContext tierContext = new HighTierContext(this.providers, new PhaseSuite<HighTierContext>(), OptimisticOptimizations.NONE);
                                this.fastPartialEvaluation(compilable, inliningPlan, graph, baseContext, tierContext, handler);
                                if (cancellable == null || !cancellable.isCancelled()) break block46;
                                structuredGraph = null;
                                if (indent == null) break block47;
                                if (throwable2 == null) break block48;
                                try {
                                    indent.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                break block47;
                            }
                            indent.close();
                        }
                        if (s == null) return structuredGraph;
                        if (throwable != null) {
                            try {
                                s.close();
                                return structuredGraph;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                return structuredGraph;
                            }
                        }
                        s.close();
                        return structuredGraph;
                    }
                    try {
                        new VerifyFrameDoesNotEscapePhase().apply(graph, false);
                        PartialEvaluator.postPartialEvaluation(graph);
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throw throwable6;
                    }
                    finally {
                        if (indent != null) {
                            if (throwable2 != null) {
                                try {
                                    indent.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable2.addSuppressed(throwable7);
                                }
                            } else {
                                indent.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                catch (Throwable throwable9) {
                    throw throwable9;
                }
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
            StructuredGraph structuredGraph = graph;
            return structuredGraph;
        }
    }

    public void parseRootGraphForInlining(CompilableTruffleAST compilable, StructuredGraph graph, CallNodeProvider callNodeProvider, InlineInvokePlugin callNodePlugin, EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCacheForInlining) {
        HighTierContext tierContext = new HighTierContext(this.providers, new PhaseSuite<HighTierContext>(), OptimisticOptimizations.NONE);
        assert (SharedTruffleCompilerOptions.TruffleLanguageAgnosticInlining.getValue(graph.getOptions()).booleanValue());
        this.doGraphPE(compilable, graph, tierContext, (TruffleInliningPlan)callNodeProvider, callNodePlugin, graphCacheForInlining);
    }

    public StructuredGraph createGraphForInlining(DebugContext debug, CompilableTruffleAST compilable, CallNodeProvider callNodeProvider, InlineInvokePlugin callNodePlugin, StructuredGraph.AllowAssumptions allowAssumptions, CompilationIdentifier compilationId, SpeculationLog log, Cancellable cancellable, EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCacheForInlining) {
        String name = compilable.toString();
        ResolvedJavaMethod rootMethod = this.inlineRootForCallTargetAgnostic(compilable);
        StructuredGraph graph = this.createGraphForPE(debug, name, rootMethod, allowAssumptions, compilationId, log, cancellable);
        HighTierContext tierContext = new HighTierContext(this.providers, new PhaseSuite<HighTierContext>(), OptimisticOptimizations.NONE);
        assert (SharedTruffleCompilerOptions.TruffleLanguageAgnosticInlining.getValue(graph.getOptions()).booleanValue());
        this.doGraphPE(compilable, graph, tierContext, (TruffleInliningPlan)callNodeProvider, callNodePlugin, graphCacheForInlining);
        return graph;
    }

    protected StructuredGraph.Builder customizeStructuredGraphBuilder(StructuredGraph.Builder builder) {
        return builder;
    }

    public ResolvedJavaMethod rootForCallTarget(CompilableTruffleAST compilable) {
        return this.callRootMethod;
    }

    public ResolvedJavaMethod inlineRootForCallTarget(CompilableTruffleAST compilable) {
        return this.callInlinedMethod;
    }

    public ResolvedJavaMethod inlineRootForCallTargetAgnostic(CompilableTruffleAST compilable) {
        return this.callInlinedAgnosticMethod;
    }

    protected PEGraphDecoder createGraphDecoder(StructuredGraph graph, HighTierContext tierContext, LoopExplosionPlugin loopExplosionPlugin, InvocationPlugins invocationPlugins, InlineInvokePlugin[] inlineInvokePlugins, ParameterPlugin parameterPlugin, NodePlugin[] nodePluginList, SourceLanguagePositionProvider sourceLanguagePositionProvider, EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCache) {
        GraphBuilderConfiguration newConfig = this.configForParsing.copy();
        InvocationPlugins parsingInvocationPlugins = newConfig.getPlugins().getInvocationPlugins();
        GraphBuilderConfiguration.Plugins plugins = newConfig.getPlugins();
        ReplacementsImpl replacements = (ReplacementsImpl)this.providers.getReplacements();
        plugins.clearInlineInvokePlugins();
        plugins.appendInlineInvokePlugin(replacements);
        plugins.appendInlineInvokePlugin(new ParsingInlineInvokePlugin(replacements, parsingInvocationPlugins, loopExplosionPlugin));
        if (!TruffleCompilerOptions.getValue(TruffleCompilerOptions.PrintTruffleExpansionHistogram).booleanValue()) {
            plugins.appendInlineInvokePlugin(new InlineDuringParsingPlugin());
        }
        DeoptimizeOnExceptionPhase postParsingPhase = new DeoptimizeOnExceptionPhase(method -> TruffleCompilerRuntime.getRuntime().getInlineKind((ResolvedJavaMethod)method, true) == TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_SPECULATIVE_EXCEPTION);
        Providers compilationUnitProviders = this.providers.copyWith(new TruffleConstantFieldProvider(this.providers.getConstantFieldProvider(), this.providers.getMetaAccess()));
        return new CachingPEGraphDecoder(this.architecture, graph, compilationUnitProviders, newConfig, TruffleCompilerImpl.Optimizations, StructuredGraph.AllowAssumptions.ifNonNull(graph.getAssumptions()), loopExplosionPlugin, this.decodingInvocationPlugins, inlineInvokePlugins, parameterPlugin, nodePluginList, this.callInlinedMethod, this.callInlinedAgnosticMethod, sourceLanguagePositionProvider, postParsingPhase, graphCache);
    }

    protected void doGraphPE(CompilableTruffleAST compilable, StructuredGraph graph, HighTierContext tierContext, TruffleInliningPlan inliningDecision, InlineInvokePlugin inlineInvokePlugin, EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCache) {
        InlineInvokePlugin[] inlineInvokePlugins;
        PELoopExplosionPlugin loopExplosionPlugin = new PELoopExplosionPlugin();
        InterceptReceiverPlugin parameterPlugin = new InterceptReceiverPlugin(compilable);
        ReplacementsImpl replacements = (ReplacementsImpl)this.providers.getReplacements();
        HistogramInlineInvokePlugin histogramPlugin = null;
        Boolean printTruffleExpansionHistogram = TruffleCompilerOptions.getValue(TruffleCompilerOptions.PrintTruffleExpansionHistogram);
        if (printTruffleExpansionHistogram.booleanValue()) {
            histogramPlugin = new HistogramInlineInvokePlugin(graph);
            inlineInvokePlugins = new InlineInvokePlugin[]{replacements, inlineInvokePlugin, histogramPlugin};
        } else {
            inlineInvokePlugins = new InlineInvokePlugin[]{replacements, inlineInvokePlugin};
        }
        TruffleSourceLanguagePositionProvider sourceLanguagePosition = new TruffleSourceLanguagePositionProvider(inliningDecision);
        PEGraphDecoder decoder = this.createGraphDecoder(graph, tierContext, loopExplosionPlugin, this.decodingInvocationPlugins, inlineInvokePlugins, parameterPlugin, this.nodePlugins, sourceLanguagePosition, graphCache);
        decoder.decode(graph.method(), graph.isSubstitution(), graph.trackNodeSourcePosition());
        if (printTruffleExpansionHistogram.booleanValue()) {
            histogramPlugin.print(compilable);
        }
    }

    protected GraphBuilderConfiguration createGraphBuilderConfig(GraphBuilderConfiguration config, boolean canDelayIntrinsification) {
        GraphBuilderConfiguration newConfig = config.copy();
        InvocationPlugins invocationPlugins = newConfig.getPlugins().getInvocationPlugins();
        this.registerTruffleInvocationPlugins(invocationPlugins, canDelayIntrinsification);
        boolean mustInstrumentBranches = TruffleCompilerOptions.getValue(TruffleCompilerOptions.TruffleInstrumentBranches) != false || TruffleCompilerOptions.getValue(TruffleCompilerOptions.TruffleInstrumentBoundaries) != false;
        return newConfig.withNodeSourcePosition(newConfig.trackNodeSourcePosition() || mustInstrumentBranches || TruffleCompilerOptions.getValue(TruffleCompilerOptions.TraceTrufflePerformanceWarnings) != false);
    }

    protected NodePlugin[] createNodePlugins(GraphBuilderConfiguration.Plugins plugins) {
        return plugins.getNodePlugins();
    }

    protected void registerTruffleInvocationPlugins(InvocationPlugins invocationPlugins, boolean canDelayIntrinsification) {
        TruffleGraphBuilderPlugins.registerInvocationPlugins(invocationPlugins, canDelayIntrinsification, this.providers, this.knownTruffleTypes);
        for (TruffleInvocationPluginProvider p : GraalServices.load(TruffleInvocationPluginProvider.class)) {
            p.registerInvocationPlugins(this.providers, this.architecture, invocationPlugins, canDelayIntrinsification);
        }
    }

    protected InvocationPlugins createDecodingInvocationPlugins(GraphBuilderConfiguration.Plugins parent) {
        InvocationPlugins decodingInvocationPlugins = new InvocationPlugins(parent.getInvocationPlugins());
        this.registerTruffleInvocationPlugins(decodingInvocationPlugins, false);
        decodingInvocationPlugins.closeRegistration();
        return decodingInvocationPlugins;
    }

    private void fastPartialEvaluation(CompilableTruffleAST compilable, TruffleInliningPlan inliningDecision, StructuredGraph graph, CoreProviders baseContext, HighTierContext tierContext, PerformanceInformationHandler handler) {
        DebugContext debug = graph.getDebug();
        this.agnosticInliningOrGraphPE(compilable, inliningDecision, graph, baseContext, tierContext);
        debug.dump(1, graph, "After Partial Evaluation");
        graph.maybeCompress();
        new ConvertDeoptimizeToGuardPhase().apply(graph, tierContext);
        for (MethodCallTargetNode methodCallTargetNode : graph.getNodes(MethodCallTargetNode.TYPE)) {
            StructuredGraph inlineGraph;
            if (!methodCallTargetNode.invoke().useForInlining() || (inlineGraph = this.providers.getReplacements().getSubstitution(methodCallTargetNode.targetMethod(), methodCallTargetNode.invoke().bci(), graph.trackNodeSourcePosition(), methodCallTargetNode.asNode().getNodeSourcePosition(), debug.getOptions())) == null) continue;
            InliningUtil.inline(methodCallTargetNode.invoke(), inlineGraph, true, methodCallTargetNode.targetMethod());
        }
        new ConditionalEliminationPhase(false).apply(graph, tierContext);
        this.canonicalizer.apply(graph, tierContext);
        try (DebugContext.Scope pe = debug.scope((Object)"TrufflePartialEscape", graph);){
            new PartialEscapePhase(TruffleCompilerOptions.getValue(TruffleCompilerOptions.TruffleIterativePartialEscape), this.canonicalizer, graph.getOptions()).apply(graph, tierContext);
        }
        catch (Throwable t) {
            debug.handle(t);
        }
        ComputeLoopFrequenciesClosure.compute(graph);
        this.applyInstrumentationPhases(graph, tierContext);
        graph.maybeCompress();
        handler.reportPerformanceWarnings(compilable, graph);
    }

    private void agnosticInliningOrGraphPE(CompilableTruffleAST compilable, TruffleInliningPlan inliningDecision, StructuredGraph graph, CoreProviders baseContext, HighTierContext tierContext) {
        if (SharedTruffleCompilerOptions.TruffleLanguageAgnosticInlining.getValue(graph.getOptions()).booleanValue()) {
            AgnosticInliningPhase agnosticInlining = new AgnosticInliningPhase(this, inliningDecision, compilable);
            agnosticInlining.apply(graph, baseContext);
        } else {
            PEInliningPlanInvokePlugin plugin = new PEInliningPlanInvokePlugin(inliningDecision, graph, TruffleCompilerOptions.TruffleMaximumGraalNodeCount.getValue(graph.getOptions()), TruffleCompilerOptions.TruffleMaximumInlineNodeCount.getValue(graph.getOptions()));
            this.doGraphPE(compilable, graph, tierContext, inliningDecision, plugin, (EconomicMap<ResolvedJavaMethod, EncodedGraph>)EconomicMap.create());
        }
        PartialEvaluator.removeIsInlinedNodes(graph);
    }

    protected void applyInstrumentationPhases(StructuredGraph graph, HighTierContext tierContext) {
        if (TruffleCompilerOptions.TruffleInstrumentBranches.getValue(graph.getOptions()).booleanValue()) {
            new InstrumentBranchesPhase(graph.getOptions(), this.snippetReflection, this.getInstrumentation()).apply(graph, tierContext);
        }
        if (TruffleCompilerOptions.TruffleInstrumentBoundaries.getValue(graph.getOptions()).booleanValue()) {
            new InstrumentTruffleBoundariesPhase(graph.getOptions(), this.snippetReflection, this.getInstrumentation()).apply(graph, tierContext);
        }
    }

    private static void postPartialEvaluation(StructuredGraph graph) {
        NeverPartOfCompilationNode.verifyNotFoundIn(graph);
        for (AllowMaterializeNode materializeNode : graph.getNodes(AllowMaterializeNode.TYPE).snapshot()) {
            materializeNode.replaceAtUsages(materializeNode.getFrame());
            graph.removeFixed(materializeNode);
        }
        TruffleCompilerRuntime rt = TruffleCompilerRuntime.getRuntime();
        for (VirtualObjectNode virtualObjectNode : graph.getNodes(VirtualObjectNode.TYPE)) {
            VirtualInstanceNode virtualInstanceNode;
            ResolvedJavaType type;
            if (!(virtualObjectNode instanceof VirtualInstanceNode) || !rt.isValueType(type = (virtualInstanceNode = (VirtualInstanceNode)virtualObjectNode).type())) continue;
            virtualInstanceNode.setIdentity(false);
        }
        if (!TruffleCompilerOptions.getValue(TruffleCompilerOptions.TruffleInlineAcrossTruffleBoundary).booleanValue()) {
            for (MethodCallTargetNode mct : graph.getNodes(MethodCallTargetNode.TYPE)) {
                TruffleCompilerRuntime.InlineKind inlineKind = rt.getInlineKind(mct.targetMethod(), false);
                if (inlineKind.allowsInlining()) continue;
                mct.invoke().setUseForInlining(false);
            }
        }
    }

    private static TruffleInliningPlan.Decision getDecision(TruffleInliningPlan inlining, JavaConstant callNode) {
        TruffleInliningPlan.Decision decision = inlining.findDecision(callNode);
        if (decision == null) {
            JavaConstant target = TruffleCompilerRuntime.getRuntime().getCallTargetForCallNode(callNode);
            PerformanceInformationHandler.reportDecisionIsNull(target, callNode);
        } else if (!decision.isTargetStable()) {
            JavaConstant target = TruffleCompilerRuntime.getRuntime().getCallTargetForCallNode(callNode);
            PerformanceInformationHandler.reportCallTargetChanged(target, callNode, decision);
            return null;
        }
        return decision;
    }

    private static InlineInvokePlugin.InlineInfo asInlineInfo(TruffleCompilerRuntime.InlineKind inlineKind, ResolvedJavaMethod method) {
        switch (inlineKind) {
            case DO_NOT_INLINE_DEOPTIMIZE_ON_EXCEPTION: {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_DEOPTIMIZE_ON_EXCEPTION;
            }
            case DO_NOT_INLINE_NO_EXCEPTION: {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_NO_EXCEPTION;
            }
            case DO_NOT_INLINE_WITH_EXCEPTION: 
            case DO_NOT_INLINE_WITH_SPECULATIVE_EXCEPTION: {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            case INLINE: {
                return InlineInvokePlugin.InlineInfo.createStandardInlineInfo(method);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)inlineKind));
    }

    public static SpeculationLog.SpeculationReason createTruffleBoundaryExceptionSpeculation(ResolvedJavaMethod targetMethod) {
        return TRUFFLE_BOUNDARY_EXCEPTION_SPECULATIONS.createSpeculationReason(targetMethod);
    }

    private static final class SourceLanguagePositionImpl
    implements SourceLanguagePosition {
        private final TruffleSourceLanguagePosition delegate;

        SourceLanguagePositionImpl(TruffleSourceLanguagePosition delegate) {
            this.delegate = delegate;
        }

        @Override
        public String toShortString() {
            return this.delegate.getDescription();
        }

        @Override
        public int getOffsetEnd() {
            return this.delegate.getOffsetEnd();
        }

        @Override
        public int getOffsetStart() {
            return this.delegate.getOffsetStart();
        }

        @Override
        public int getLineNumber() {
            return this.delegate.getLineNumber();
        }

        @Override
        public URI getURI() {
            return this.delegate.getURI();
        }

        @Override
        public String getLanguage() {
            return this.delegate.getLanguage();
        }
    }

    public static final class PerformanceInformationHandler
    implements Closeable {
        private static final ThreadLocal<PerformanceInformationHandler> instance = new ThreadLocal();
        private boolean warningSeen;

        private PerformanceInformationHandler() {
        }

        private void setWarnings(boolean hasWarnings) {
            this.warningSeen = hasWarnings;
        }

        private boolean hasWarnings() {
            return this.warningSeen;
        }

        @Override
        public void close() {
            assert (instance.get() != null) : "No PerformanceInformationHandler installed";
            instance.remove();
        }

        static PerformanceInformationHandler install() {
            assert (instance.get() == null) : "PerformanceInformationHandler already installed";
            PerformanceInformationHandler handler = new PerformanceInformationHandler();
            instance.set(handler);
            return handler;
        }

        public static boolean isEnabled() {
            return TruffleCompilerOptions.getValue(TruffleCompilerOptions.TraceTrufflePerformanceWarnings) != false || TruffleCompilerOptions.getValue(SharedTruffleCompilerOptions.TrufflePerformanceWarningsAreFatal) != false;
        }

        public static void logPerformanceWarning(String callTargetName, List<? extends Node> locations, String details, Map<String, Object> properties) {
            instance.get().setWarnings(true);
            PerformanceInformationHandler.logPerformanceWarningImpl(callTargetName, "perf warn", details, properties);
            PerformanceInformationHandler.logPerformanceStackTrace(locations);
        }

        private static void logPerformanceInfo(String callTargetName, List<? extends Node> locations, String details, Map<String, Object> properties) {
            PerformanceInformationHandler.logPerformanceWarningImpl(callTargetName, "perf info", details, properties);
            PerformanceInformationHandler.logPerformanceStackTrace(locations);
        }

        private static void logPerformanceWarningImpl(String callTargetName, String msg, String details, Map<String, Object> properties) {
            TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
            runtime.logEvent(0, msg, String.format("%-60s|%s", callTargetName, details), properties);
        }

        private static void logPerformanceStackTrace(List<? extends Node> locations) {
            if (locations == null || locations.isEmpty()) {
                return;
            }
            int limit = TruffleCompilerOptions.getValue(SharedTruffleCompilerOptions.TraceTruffleStackTraceLimit);
            if (limit <= 0) {
                return;
            }
            EconomicMap groupedByStackTrace = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
            for (Node node : locations) {
                String stackTraceAsString;
                StackTraceElement[] stackTrace = GraphUtil.approxSourceStackTraceElement(node);
                StringBuilder sb = new StringBuilder();
                String indent = "    ";
                for (int i = 0; i < stackTrace.length && i < limit; ++i) {
                    if (i != 0) {
                        sb.append('\n');
                    }
                    sb.append(indent).append("at ").append(stackTrace[i]);
                }
                if (stackTrace.length > limit) {
                    sb.append('\n').append(indent).append("...");
                }
                if (!groupedByStackTrace.containsKey((Object)(stackTraceAsString = sb.toString()))) {
                    groupedByStackTrace.put((Object)stackTraceAsString, new ArrayList());
                }
                ((List)groupedByStackTrace.get((Object)stackTraceAsString)).add(node);
            }
            MapCursor entry = groupedByStackTrace.getEntries();
            while (entry.advance()) {
                String string = (String)entry.getKey();
                List locationGroup = (List)entry.getValue();
                TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
                if (string.isEmpty()) {
                    runtime.log(String.format("  No stack trace available for %s.", locationGroup));
                    continue;
                }
                runtime.log(String.format("  Approximated stack trace for %s:", locationGroup));
                runtime.log(string);
            }
        }

        void reportPerformanceWarnings(CompilableTruffleAST target, StructuredGraph graph) {
            if (!PerformanceInformationHandler.isEnabled()) {
                return;
            }
            DebugContext debug = graph.getDebug();
            ArrayList<ValueNode> warnings = new ArrayList<ValueNode>();
            for (MethodCallTargetNode methodCallTargetNode : graph.getNodes(MethodCallTargetNode.TYPE)) {
                TruffleCompilerRuntime runtime;
                if (methodCallTargetNode.targetMethod().isNative() || !(runtime = TruffleCompilerRuntime.getRuntime()).getInlineKind(methodCallTargetNode.targetMethod(), true).allowsInlining()) continue;
                PerformanceInformationHandler.logPerformanceWarning(target.getName(), Arrays.asList(methodCallTargetNode), String.format("not inlined %s call to %s (%s)", new Object[]{methodCallTargetNode.invokeKind(), methodCallTargetNode.targetMethod(), methodCallTargetNode}), null);
                warnings.add(methodCallTargetNode);
            }
            EconomicMap groupedByType = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
            for (InstanceOfNode instanceOf : graph.getNodes().filter(InstanceOfNode.class)) {
                ResolvedJavaType type;
                if (instanceOf.type().isExact() || !PerformanceInformationHandler.isSecondaryType(type = instanceOf.type().getType())) continue;
                warnings.add(instanceOf);
                if (!groupedByType.containsKey((Object)type)) {
                    groupedByType.put((Object)type, new ArrayList());
                }
                ((ArrayList)groupedByType.get((Object)type)).add(instanceOf);
            }
            MapCursor mapCursor = groupedByType.getEntries();
            while (mapCursor.advance()) {
                ResolvedJavaType type = (ResolvedJavaType)mapCursor.getKey();
                String reason = type.isInterface() ? String.format("interface type check: %s", type) : String.format("too deep in class hierarchy: %s", type);
                PerformanceInformationHandler.logPerformanceInfo(target.getName(), (List)mapCursor.getValue(), reason, Collections.singletonMap("Nodes", mapCursor.getValue()));
            }
            if (debug.areScopesEnabled() && !warnings.isEmpty()) {
                try (DebugContext.Scope s = debug.scope((Object)"TrufflePerformanceWarnings", graph);){
                    debug.dump(1, (Object)graph, "performance warnings %s", warnings);
                }
                catch (Throwable t) {
                    debug.handle(t);
                }
            }
            if (this.hasWarnings() && TruffleCompilerOptions.getValue(SharedTruffleCompilerOptions.TrufflePerformanceWarningsAreFatal).booleanValue()) {
                throw new AssertionError((Object)"Performance warning detected and is fatal.");
            }
        }

        private static boolean isPrimarySupertype(ResolvedJavaType type) {
            if (type.isInterface()) {
                return false;
            }
            int depth = 0;
            for (ResolvedJavaType supr = type; supr != null; supr = supr.getSuperclass()) {
                ++depth;
            }
            return depth <= 8;
        }

        private static boolean isSecondaryType(ResolvedJavaType type) {
            return !PerformanceInformationHandler.isPrimarySupertype(type);
        }

        static void reportDecisionIsNull(JavaConstant target, JavaConstant callNode) {
            if (!PerformanceInformationHandler.isEnabled()) {
                return;
            }
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            properties.put("callNode", callNode.toValueString());
            PerformanceInformationHandler.logPerformanceWarning(target.toValueString(), null, "A direct call within the Truffle AST is not reachable anymore. Call node could not be inlined.", properties);
        }

        static void reportCallTargetChanged(JavaConstant target, JavaConstant callNode, TruffleInliningPlan.Decision decision) {
            if (!PerformanceInformationHandler.isEnabled()) {
                return;
            }
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            properties.put("originalTarget", decision.getTargetName());
            properties.put("callNode", callNode.toValueString());
            PerformanceInformationHandler.logPerformanceWarning(target.toValueString(), null, "CallTarget changed during compilation. Call node could not be inlined.", properties);
        }
    }

    private class PELoopExplosionPlugin
    implements LoopExplosionPlugin {
        private PELoopExplosionPlugin() {
        }

        @Override
        public LoopExplosionPlugin.LoopExplosionKind loopExplosionKind(ResolvedJavaMethod method) {
            TruffleCompilerRuntime rt = TruffleCompilerRuntime.getRuntime();
            TruffleCompilerRuntime.LoopExplosionKind explosionKind = rt.getLoopExplosionKind(method);
            switch (explosionKind) {
                case NONE: {
                    return LoopExplosionPlugin.LoopExplosionKind.NONE;
                }
                case FULL_EXPLODE: {
                    return LoopExplosionPlugin.LoopExplosionKind.FULL_EXPLODE;
                }
                case FULL_EXPLODE_UNTIL_RETURN: {
                    return LoopExplosionPlugin.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN;
                }
                case FULL_UNROLL: {
                    return LoopExplosionPlugin.LoopExplosionKind.FULL_UNROLL;
                }
                case MERGE_EXPLODE: {
                    return LoopExplosionPlugin.LoopExplosionKind.MERGE_EXPLODE;
                }
            }
            throw new IllegalStateException("Unsupported TruffleCompilerRuntime.LoopExplosionKind: " + String.valueOf((Object)explosionKind));
        }
    }

    private class ParsingInlineInvokePlugin
    implements InlineInvokePlugin {
        private final ReplacementsImpl replacements;
        private final InvocationPlugins invocationPlugins;
        private final LoopExplosionPlugin loopExplosionPlugin;

        ParsingInlineInvokePlugin(ReplacementsImpl replacements, InvocationPlugins invocationPlugins, LoopExplosionPlugin loopExplosionPlugin) {
            this.replacements = replacements;
            this.invocationPlugins = invocationPlugins;
            this.loopExplosionPlugin = loopExplosionPlugin;
        }

        private boolean hasMethodHandleArgument(ValueNode[] arguments) {
            for (ValueNode argument : arguments) {
                JavaConstant constant;
                if (!argument.isConstant() || (constant = argument.asJavaConstant()).getJavaKind() != JavaKind.Object || !constant.isNonNull() || !((PartialEvaluator)PartialEvaluator.this).knownTruffleTypes.classMethodHandle.isInstance(constant)) continue;
                return true;
            }
            return false;
        }

        @Override
        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext builder, ResolvedJavaMethod original, ValueNode[] arguments) {
            if (this.invocationPlugins.lookupInvocation(original) != null || this.replacements.hasSubstitution(original, builder.bci())) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (this.loopExplosionPlugin.loopExplosionKind(original) != LoopExplosionPlugin.LoopExplosionKind.NONE) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            TruffleCompilerRuntime rt = TruffleCompilerRuntime.getRuntime();
            InlineInvokePlugin.InlineInfo inlineInfo = PartialEvaluator.asInlineInfo(rt.getInlineKind(original, true), original);
            if (!inlineInfo.allowsInlining()) {
                return inlineInfo;
            }
            if (original.equals(PartialEvaluator.this.callIndirectMethod) || original.equals(PartialEvaluator.this.callInlinedAgnosticMethod) || original.equals(PartialEvaluator.this.callDirectMethod)) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (this.hasMethodHandleArgument(arguments)) {
                return inlineInfo;
            }
            return null;
        }
    }

    public static class TruffleSourceLanguagePositionProvider
    implements SourceLanguagePositionProvider {
        private TruffleInliningPlan inliningPlan;

        public TruffleSourceLanguagePositionProvider(TruffleInliningPlan inliningPlan) {
            this.inliningPlan = inliningPlan;
        }

        @Override
        public SourceLanguagePosition getPosition(JavaConstant node) {
            TruffleSourceLanguagePosition position = this.inliningPlan.getPosition(node);
            return position == null ? null : new SourceLanguagePositionImpl(position);
        }
    }

    private class PEInliningPlanInvokePlugin
    extends PEInlineInvokePlugin {
        private final Deque<TruffleInliningPlan> inlining = new ArrayDeque<TruffleInliningPlan>();
        private final int nodeLimit;
        private final StructuredGraph graph;
        private final int inliningNodeLimit;
        private boolean graphTooBigReported;

        PEInliningPlanInvokePlugin(TruffleInliningPlan inlining, StructuredGraph graph, int nodeLimit, int inliningNodeLimit) {
            this.inlining.push(inlining);
            this.graph = graph;
            this.nodeLimit = nodeLimit;
            this.inliningNodeLimit = inliningNodeLimit;
        }

        @Override
        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext builder, ResolvedJavaMethod original, ValueNode[] arguments) {
            if (this.graph.getNodeCount() > this.nodeLimit) {
                throw builder.bailout("Graph too big to safely compile. Node count: " + this.graph.getNodeCount() + ". Limit: " + this.nodeLimit);
            }
            TruffleCompilerRuntime rt = TruffleCompilerRuntime.getRuntime();
            InlineInvokePlugin.InlineInfo inlineInfo = PartialEvaluator.asInlineInfo(rt.getInlineKind(original, true), original);
            if (!inlineInfo.allowsInlining()) {
                return inlineInfo;
            }
            assert (!builder.parsingIntrinsic());
            if (original.equals(PartialEvaluator.this.callDirectMethod)) {
                ValueNode arg0 = arguments[1];
                if (!arg0.isConstant()) {
                    GraalError.shouldNotReachHere("The direct call node does not resolve to a constant!");
                }
                if (this.graph.getNodeCount() > this.inliningNodeLimit) {
                    this.logGraphTooBig();
                    return inlineInfo;
                }
                TruffleInliningPlan.Decision decision = PartialEvaluator.getDecision(this.inlining.peek(), (JavaConstant)arg0.asConstant());
                if (decision != null && decision.shouldInline()) {
                    this.inlining.push(decision);
                    JavaConstant assumption = decision.getNodeRewritingAssumption();
                    builder.getAssumptions().record((Assumptions.Assumption)new TruffleAssumption(assumption));
                    return InlineInvokePlugin.InlineInfo.createStandardInlineInfo(PartialEvaluator.this.callInlinedMethod);
                }
            }
            return inlineInfo;
        }

        private void logGraphTooBig() {
            if (!this.graphTooBigReported && TruffleCompilerOptions.getValue(SharedTruffleCompilerOptions.TraceTruffleInlining).booleanValue()) {
                this.graphTooBigReported = true;
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("graph node count", this.graph.getNodeCount());
                properties.put("graph node limit", this.inliningNodeLimit);
                TruffleCompilerRuntime.getRuntime().logEvent(0, "Truffle inlining caused graal node count to be too big during partial evaluation.", "", properties);
            }
        }

        @Override
        public void notifyAfterInline(ResolvedJavaMethod inlinedTargetMethod) {
            if (inlinedTargetMethod.equals(PartialEvaluator.this.callInlinedMethod)) {
                this.inlining.pop();
            }
        }
    }

    public static class PEInlineInvokePlugin
    implements InlineInvokePlugin {
        @Override
        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext builder, ResolvedJavaMethod original, ValueNode[] arguments) {
            TruffleCompilerRuntime rt = TruffleCompilerRuntime.getRuntime();
            InlineInvokePlugin.InlineInfo inlineInfo = PartialEvaluator.asInlineInfo(rt.getInlineKind(original, true), original);
            if (!inlineInfo.allowsInlining()) {
                return inlineInfo;
            }
            assert (!builder.parsingIntrinsic());
            return inlineInfo;
        }
    }

    private class InterceptReceiverPlugin
    implements ParameterPlugin {
        private final CompilableTruffleAST compilable;

        InterceptReceiverPlugin(CompilableTruffleAST compilable) {
            this.compilable = compilable;
        }

        @Override
        public FloatingNode interceptParameter(GraphBuilderTool b, int index, StampPair stamp) {
            if (index == 0) {
                JavaConstant c = this.compilable.asJavaConstant();
                return ConstantNode.forConstant(c, PartialEvaluator.this.providers.getMetaAccess());
            }
            return null;
        }
    }
}

