/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import java.util.Map;
import jdk.vm.ci.common.NativeImageReinitialize;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.truffle.common.SharedTruffleOptions;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.SharedTruffleCompilerOptions;

@SharedTruffleOptions(name="SharedTruffleCompilerOptions", runtime=false)
public final class TruffleCompilerOptions {
    @Option(help={"Exclude assertion code from Truffle compilations"}, type=OptionType.Debug)
    public static final OptionKey<Boolean> TruffleExcludeAssertions = new OptionKey<Boolean>(true);
    @Option(help={"Enable inlining across Truffle boundary"}, type=OptionType.Expert)
    public static final OptionKey<Boolean> TruffleInlineAcrossTruffleBoundary = new OptionKey<Boolean>(false);
    @Option(help={"Print potential performance problems"}, type=OptionType.Debug)
    public static final OptionKey<Boolean> TraceTrufflePerformanceWarnings = new OptionKey<Boolean>(false);
    @Option(help={"Prints a histogram of all expanded Java methods."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> PrintTruffleExpansionHistogram = new OptionKey<Boolean>(false);
    @Option(help={"Enable support for simple infopoints in truffle partial evaluations."}, type=OptionType.Expert)
    public static final OptionKey<Boolean> TruffleEnableInfopoints = new OptionKey<Boolean>(false);
    @Option(help={"Run the partial escape analysis iteratively in Truffle compilation."}, type=OptionType.Debug)
    public static final OptionKey<Boolean> TruffleIterativePartialEscape = new OptionKey<Boolean>(false);
    @Option(help={"Instrument branches and output profiling information to the standard output."})
    public static final OptionKey<Boolean> TruffleInstrumentBranches = new OptionKey<Boolean>(false);
    @Option(help={"Instrument branches by considering different inlining sites as different branches."})
    public static final OptionKey<Boolean> TruffleInstrumentBranchesPerInlineSite = new OptionKey<Boolean>(false);
    @Option(help={"Instrument Truffle boundaries and output profiling information to the standard output."})
    public static final OptionKey<Boolean> TruffleInstrumentBoundaries = new OptionKey<Boolean>(false);
    @Option(help={"Instrument Truffle boundaries by considering different inlining sites as different branches."})
    public static final OptionKey<Boolean> TruffleInstrumentBoundariesPerInlineSite = new OptionKey<Boolean>(false);
    @Option(help={"Method filter for host methods in which to add instrumentation."})
    public static final OptionKey<String> TruffleInstrumentFilter = new OptionKey<String>("*.*.*");
    @Option(help={"Maximum number of instrumentation counters available."})
    public static final OptionKey<Integer> TruffleInstrumentationTableSize = new OptionKey<Integer>(10000);
    @Option(help={"Stop partial evaluation when the graph exceeded this many nodes."})
    public static final OptionKey<Integer> TruffleMaximumGraalNodeCount = new OptionKey<Integer>(400000);
    @Option(help={"Ignore further truffle inlining decisions when the graph exceeded this many nodes."})
    public static final OptionKey<Integer> TruffleMaximumInlineNodeCount = new OptionKey<Integer>(150000);
    @Option(help={"Intrinsify get/set/is methods of FrameWithoutBoxing to improve Truffle compilation time"}, type=OptionType.Debug)
    public static final OptionKey<Boolean> TruffleIntrinsifyFrameAccess = new OptionKey<Boolean>(true);
    @Option(help={"Print detailed information for inlining (i.e. the entire explored call tree)."}, type=OptionType.Expert)
    public static final OptionKey<Boolean> TraceTruffleInliningDetails = new OptionKey<Boolean>(false);
    @Option(help={"Explicitly pick a inlining policy by name. Highest priority chosen by default."}, type=OptionType.Expert)
    public static final OptionKey<String> TruffleInliningPolicy = new OptionKey<String>("");
    @Option(help={"The base expansion budget for language-agnostic inlining."}, type=OptionType.Expert)
    public static final OptionKey<Integer> TruffleInliningExpansionBudget = new OptionKey<Integer>(50000);
    @Option(help={"The base inlining budget for language-agnostic inlining"}, type=OptionType.Expert)
    public static final OptionKey<Integer> TruffleInliningInliningBudget = new OptionKey<Integer>(50000);
    @NativeImageReinitialize
    private static volatile OptionValues optionValues;

    private TruffleCompilerOptions() {
        throw new IllegalStateException("No instance allowed.");
    }

    private static OptionValues getInitialOptions() {
        OptionValues result = optionValues;
        if (result == null) {
            optionValues = result = TruffleCompilerRuntime.getRuntime().getOptions(OptionValues.class);
        }
        return result;
    }

    public static boolean areTruffleCompilationExceptionsFatal() {
        boolean compilationExceptionsAreFatal = TruffleCompilerOptions.getValue(SharedTruffleCompilerOptions.TruffleCompilationExceptionsAreFatal);
        boolean performanceWarningsAreFatal = TruffleCompilerOptions.getValue(SharedTruffleCompilerOptions.TrufflePerformanceWarningsAreFatal);
        return compilationExceptionsAreFatal || performanceWarningsAreFatal;
    }

    public static OptionValues getOptions() {
        TruffleOptionsOverrideScope scope = Lazy.overrideScope.get();
        return scope != null ? scope.options : TruffleCompilerOptions.getInitialOptions();
    }

    public static OptionValues getCurrentOptionOverrides() {
        TruffleOptionsOverrideScope scope = Lazy.overrideScope.get();
        return scope != null ? scope.options : null;
    }

    public static TruffleOptionsOverrideScope overrideOptions(OptionKey<?> key1, Object value1, Object ... extraOverrides) {
        return new TruffleOptionsOverrideScope((UnmodifiableEconomicMap)OptionValues.asMap(key1, value1, extraOverrides));
    }

    public static TruffleOptionsOverrideScope overrideOptions(UnmodifiableEconomicMap<OptionKey<?>, Object> overrides) {
        return new TruffleOptionsOverrideScope(overrides);
    }

    public static TruffleOptionsOverrideScope overrideOptions(Map<String, Object> overrides) {
        TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
        UnmodifiableEconomicMap<OptionKey<?>, Object> values = runtime.convertOptions(OptionValues.class, overrides).getMap();
        return new TruffleOptionsOverrideScope(values);
    }

    public static <T> T getValue(OptionKey<T> key) {
        return key.getValue(TruffleCompilerOptions.getOptions());
    }

    public static final class TruffleOptionsOverrideScope
    implements AutoCloseable {
        private final TruffleOptionsOverrideScope outer = Lazy.overrideScope.get();
        private final OptionValues options;

        private TruffleOptionsOverrideScope(UnmodifiableEconomicMap<OptionKey<?>, Object> overrides) {
            this.options = new OptionValues(this.outer == null ? TruffleCompilerOptions.getInitialOptions() : this.outer.options, overrides);
            Lazy.overrideScope.set(this);
        }

        public OptionValues getOptions() {
            return this.options;
        }

        @Override
        public void close() {
            Lazy.overrideScope.set(this.outer);
        }
    }

    static class Lazy {
        static final ThreadLocal<TruffleOptionsOverrideScope> overrideScope = new ThreadLocal();

        Lazy() {
        }
    }
}

