/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.amd64.substitutions;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.replacements.JDK9StringSubstitutions;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.StringSubstitutions;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayIndexOf;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsNode;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.word.Word;

@ClassSubstitution(className={"com.oracle.truffle.api.ArrayUtils"}, optional=true)
public class AMD64ArrayUtilsSubstitutions {
    static final MetaAccessProvider INJECTED_METAACCESS = null;

    @MethodSubstitution(optional=true)
    public static int runIndexOf(String str, int fromIndex, int maxIndex, char ... chars) {
        if (fromIndex >= str.length()) {
            return -1;
        }
        if (chars.length <= 4) {
            if (JavaVersionUtil.JAVA_SPEC <= 8) {
                return AMD64ArrayUtilsSubstitutions.indexOfChar(StringSubstitutions.getValue(str), maxIndex, fromIndex, chars);
            }
            byte[] sourceArray = JDK9StringSubstitutions.getValue(str);
            if (JDK9StringSubstitutions.isCompactString(str)) {
                int values = 0;
                int nValues = 0;
                for (int i = 0; i < chars.length; ++i) {
                    if (chars[i] > '\u00ff') continue;
                    values = values << 8 | chars[i];
                    ++nValues;
                }
                return nValues == 0 ? -1 : AMD64ArrayUtilsSubstitutions.indexOfByte(sourceArray, maxIndex, fromIndex, values, nValues);
            }
            return AMD64ArrayUtilsSubstitutions.indexOfChar(sourceArray, maxIndex, fromIndex, chars);
        }
        return AMD64ArrayUtilsSubstitutions.runIndexOf(str, fromIndex, maxIndex, chars);
    }

    @MethodSubstitution(optional=true)
    public static int runIndexOf(char[] array, int fromIndex, int maxIndex, char ... chars) {
        if (fromIndex >= array.length) {
            return -1;
        }
        if (chars.length <= 4) {
            return AMD64ArrayUtilsSubstitutions.indexOfChar(array, maxIndex, fromIndex, chars);
        }
        return AMD64ArrayUtilsSubstitutions.runIndexOf(array, fromIndex, maxIndex, chars);
    }

    @MethodSubstitution(optional=true)
    public static int runIndexOf(byte[] array, int fromIndex, int maxIndex, byte ... bytes) {
        if (fromIndex >= array.length) {
            return -1;
        }
        if (bytes.length <= 4) {
            return AMD64ArrayUtilsSubstitutions.indexOfByte(array, maxIndex, fromIndex, bytes, bytes.length);
        }
        return AMD64ArrayUtilsSubstitutions.runIndexOf(array, fromIndex, maxIndex, bytes);
    }

    private static int indexOfChar(char[] array, int arrayLength, int fromIndex, char[] chars) {
        if (chars.length == 1) {
            return AMD64ArrayIndexOf.indexOf1Char(array, arrayLength, fromIndex, chars[0]);
        }
        if (chars.length == 2) {
            return AMD64ArrayIndexOf.indexOf2Chars(array, arrayLength, fromIndex, chars[0], chars[1]);
        }
        if (chars.length == 3) {
            return AMD64ArrayIndexOf.indexOf3Chars(array, arrayLength, fromIndex, chars[0], chars[1], chars[2]);
        }
        return AMD64ArrayIndexOf.indexOf4Chars(array, arrayLength, fromIndex, chars[0], chars[1], chars[2], chars[3]);
    }

    private static int indexOfChar(byte[] array, int arrayLength, int fromIndex, char[] chars) {
        if (chars.length == 1) {
            return AMD64ArrayIndexOf.indexOf1Char(array, arrayLength, fromIndex, chars[0]);
        }
        if (chars.length == 2) {
            return AMD64ArrayIndexOf.indexOf2Chars(array, arrayLength, fromIndex, chars[0], chars[1]);
        }
        if (chars.length == 3) {
            return AMD64ArrayIndexOf.indexOf3Chars(array, arrayLength, fromIndex, chars[0], chars[1], chars[2]);
        }
        return AMD64ArrayIndexOf.indexOf4Chars(array, arrayLength, fromIndex, chars[0], chars[1], chars[2], chars[3]);
    }

    private static int indexOfByte(byte[] array, int arrayLength, int fromIndex, byte[] bytes, int nValues) {
        if (nValues == 1) {
            return AMD64ArrayIndexOf.indexOf1Byte(array, arrayLength, fromIndex, bytes[0]);
        }
        if (nValues == 2) {
            return AMD64ArrayIndexOf.indexOf2Bytes(array, arrayLength, fromIndex, bytes[0], bytes[1]);
        }
        if (nValues == 3) {
            return AMD64ArrayIndexOf.indexOf3Bytes(array, arrayLength, fromIndex, bytes[0], bytes[1], bytes[2]);
        }
        return AMD64ArrayIndexOf.indexOf4Bytes(array, arrayLength, fromIndex, bytes[0], bytes[1], bytes[2], bytes[3]);
    }

    private static int indexOfByte(byte[] array, int arrayLength, int fromIndex, int values, int nValues) {
        if (nValues == 1) {
            return AMD64ArrayIndexOf.indexOf1Byte(array, arrayLength, fromIndex, (byte)values);
        }
        if (nValues == 2) {
            return AMD64ArrayIndexOf.indexOf2Bytes(array, arrayLength, fromIndex, (byte)values, (byte)(values >>> 8));
        }
        if (nValues == 3) {
            return AMD64ArrayIndexOf.indexOf3Bytes(array, arrayLength, fromIndex, (byte)values, (byte)(values >>> 8), (byte)(values >>> 16));
        }
        return AMD64ArrayIndexOf.indexOf4Bytes(array, arrayLength, fromIndex, (byte)values, (byte)(values >>> 8), (byte)(values >>> 16), (byte)(values >>> 24));
    }

    @MethodSubstitution(optional=true)
    private static boolean runRegionEquals(byte[] a1, int fromIndex1, byte[] a2, int fromIndex2, int length) {
        return ArrayRegionEqualsNode.regionEquals(AMD64ArrayUtilsSubstitutions.bytePointer(a1, fromIndex1), AMD64ArrayUtilsSubstitutions.bytePointer(a2, fromIndex2), length, JavaKind.Byte);
    }

    @MethodSubstitution(optional=true)
    private static boolean runRegionEquals(char[] a1, int fromIndex1, char[] a2, int fromIndex2, int length) {
        return ArrayRegionEqualsNode.regionEquals(AMD64ArrayUtilsSubstitutions.charPointer(a1, fromIndex1), AMD64ArrayUtilsSubstitutions.charPointer(a2, fromIndex2), length, JavaKind.Char);
    }

    @MethodSubstitution(optional=true)
    private static boolean runRegionEquals(String a1, int fromIndex1, String a2, int fromIndex2, int length) {
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            boolean compact1 = JDK9StringSubstitutions.isCompactString(a1);
            if (compact1 != JDK9StringSubstitutions.isCompactString(a2)) {
                return ArrayRegionEqualsNode.regionEquals(compact1 ? AMD64ArrayUtilsSubstitutions.charPointer(a2, fromIndex2) : AMD64ArrayUtilsSubstitutions.charPointer(a1, fromIndex1), compact1 ? AMD64ArrayUtilsSubstitutions.bytePointer(a1, fromIndex1) : AMD64ArrayUtilsSubstitutions.bytePointer(a2, fromIndex2), length, JavaKind.Char, JavaKind.Byte);
            }
            if (compact1) {
                return ArrayRegionEqualsNode.regionEquals(AMD64ArrayUtilsSubstitutions.bytePointer(a1, fromIndex1), AMD64ArrayUtilsSubstitutions.bytePointer(a2, fromIndex2), length, JavaKind.Byte, JavaKind.Byte);
            }
            return ArrayRegionEqualsNode.regionEquals(AMD64ArrayUtilsSubstitutions.charPointer(a1, fromIndex1), AMD64ArrayUtilsSubstitutions.charPointer(a2, fromIndex2), length, JavaKind.Char, JavaKind.Char);
        }
        return ArrayRegionEqualsNode.regionEquals(AMD64ArrayUtilsSubstitutions.charPointer(a1, fromIndex1), AMD64ArrayUtilsSubstitutions.charPointer(a2, fromIndex2), length, JavaKind.Char);
    }

    private static Word bytePointer(byte[] a, int fromIndex) {
        return AMD64ArrayUtilsSubstitutions.pointer(Word.objectToTrackedPointer(a), fromIndex, JavaKind.Byte);
    }

    private static Word bytePointer(String s, int fromIndex) {
        return AMD64ArrayUtilsSubstitutions.pointer(Word.objectToTrackedPointer(AMD64ArrayUtilsSubstitutions.getValue(s)), fromIndex, JavaKind.Byte);
    }

    private static Word charPointer(char[] a, int fromIndex) {
        return AMD64ArrayUtilsSubstitutions.pointer(Word.objectToTrackedPointer(a), fromIndex, JavaKind.Char);
    }

    private static Word charPointer(String s, int fromIndex) {
        return AMD64ArrayUtilsSubstitutions.pointer(Word.objectToTrackedPointer(AMD64ArrayUtilsSubstitutions.getValue(s)), fromIndex, JavaKind.Char);
    }

    private static Word pointer(Word p, int fromIndex, JavaKind kind) {
        return p.add(ReplacementsUtil.getArrayBaseOffset(INJECTED_METAACCESS, kind)).add(fromIndex * ReplacementsUtil.arrayIndexScale(INJECTED_METAACCESS, kind));
    }

    private static Object getValue(String s) {
        return JavaVersionUtil.JAVA_SPEC > 8 ? JDK9StringSubstitutions.getValue(s) : (byte[])StringSubstitutions.getValue(s);
    }
}

