/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.VirtualState;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;

public class HistogramInlineInvokePlugin
implements InlineInvokePlugin {
    private final Map<ResolvedJavaMethod, MethodStatistics> histogram = new HashMap<ResolvedJavaMethod, MethodStatistics>();
    private final StructuredGraph graph;
    private MethodStatistic currentStatistic;

    public HistogramInlineInvokePlugin(StructuredGraph graph) {
        this.graph = graph;
    }

    @Override
    public void notifyBeforeInline(ResolvedJavaMethod methodToInline) {
        this.currentStatistic = new MethodStatistic(this.currentStatistic, methodToInline, this.countNodes(), this.countCalls());
    }

    @Override
    public void notifyAfterInline(ResolvedJavaMethod methodToInline) {
        assert (methodToInline.equals(this.currentStatistic.method));
        this.currentStatistic.applyNodeCountAfter(this.countNodes());
        this.currentStatistic.applyCallsAfter(this.countCalls());
        this.accept(this.currentStatistic);
        this.currentStatistic = this.currentStatistic.getParent();
    }

    private int countNodes() {
        return this.graph.getNodes().filter(node -> HistogramInlineInvokePlugin.isNonTrivial(node)).count();
    }

    private int countCalls() {
        return this.graph.getNodes(MethodCallTargetNode.TYPE).count();
    }

    private static boolean isNonTrivial(Node node) {
        return !(node instanceof VirtualState) && !(node instanceof VirtualObjectNode) && !(node instanceof BeginNode) && !(node instanceof DeoptimizeNode);
    }

    private void accept(MethodStatistic current) {
        ResolvedJavaMethod method = current.getMethod();
        MethodStatistics statistics = this.histogram.get(method);
        if (statistics == null) {
            statistics = new MethodStatistics(method);
            this.histogram.put(method, statistics);
        }
        statistics.accept(current);
    }

    public void print(CompilableTruffleAST target) {
        TruffleCompilerRuntime tcr = TruffleCompilerRuntime.getRuntime();
        tcr.log(String.format("Truffle expansion histogram for %s", target));
        tcr.log("  Invocations = Number of expanded invocations");
        tcr.log("  Nodes = Number of non-trival Graal nodes created for this method during partial evaluation.");
        tcr.log("  Calls = Number of not expanded calls created for this method during partial evaluation.");
        tcr.log(String.format(" %-11s |Nodes %5s %5s %5s %8s |Calls %5s %5s %5s %8s | Method Name", "Invocations", "Sum", "Min", "Max", "Avg", "Sum", "Min", "Max", "Avg"));
        ArrayList<MethodStatistics> statisticsList = new ArrayList<MethodStatistics>();
        for (MethodStatistics statistics : this.histogram.values()) {
            if (statistics.shallowCount.getSum() <= 0L) continue;
            statisticsList.add(statistics);
        }
        Collections.sort(statisticsList);
        for (MethodStatistics statistics : statisticsList) {
            statistics.print();
        }
    }

    private static class MethodStatistic {
        private final MethodStatistic parent;
        private final List<MethodStatistic> children = new ArrayList<MethodStatistic>();
        private final ResolvedJavaMethod method;
        private int deepNodeCount;
        private int callCount;

        MethodStatistic(MethodStatistic parent, ResolvedJavaMethod method, int nodeCountBefore, int callsBefore) {
            this.parent = parent;
            this.method = method;
            this.callCount = callsBefore;
            this.deepNodeCount = nodeCountBefore;
            if (parent != null) {
                this.parent.getChildren().add(this);
            }
        }

        public ResolvedJavaMethod getMethod() {
            return this.method;
        }

        public List<MethodStatistic> getChildren() {
            return this.children;
        }

        public int getShallowNodeCount() {
            int shallowCount = this.deepNodeCount;
            for (MethodStatistic child : this.children) {
                shallowCount -= child.deepNodeCount;
            }
            return shallowCount;
        }

        public int getShallowCallCount() {
            int shallowCount = this.callCount;
            for (MethodStatistic child : this.children) {
                shallowCount -= child.callCount;
            }
            return shallowCount;
        }

        public void applyNodeCountAfter(int nodeCountAfter) {
            this.deepNodeCount = nodeCountAfter - this.deepNodeCount;
        }

        public void applyCallsAfter(int callsAfter) {
            this.callCount = callsAfter - this.callCount;
        }

        public MethodStatistic getParent() {
            return this.parent;
        }
    }

    private static class MethodStatistics
    implements Comparable<MethodStatistics> {
        private final ResolvedJavaMethod method;
        private int count;
        private final IntSummaryStatistics shallowCount = new IntSummaryStatistics();
        private final IntSummaryStatistics callCount = new IntSummaryStatistics();

        MethodStatistics(ResolvedJavaMethod method) {
            this.method = method;
        }

        public void print() {
            TruffleCompilerRuntime.getRuntime().log(String.format(" %11d |      %5d %5d %5d %8.2f |      %5d %5d %5d %8.2f | %s", this.count, this.shallowCount.getSum(), this.shallowCount.getMin(), this.shallowCount.getMax(), this.shallowCount.getAverage(), this.callCount.getSum(), this.callCount.getMin(), this.callCount.getMax(), this.callCount.getAverage(), this.method.format("%h.%n(%p)")));
        }

        @Override
        public int compareTo(MethodStatistics o) {
            int result = Long.compare(o.shallowCount.getSum(), this.shallowCount.getSum());
            if (result == 0) {
                return Integer.compare(o.count, this.count);
            }
            return result;
        }

        public void accept(MethodStatistic statistic) {
            if (!statistic.method.equals(this.method)) {
                throw new IllegalArgumentException("invalid statistic");
            }
            ++this.count;
            this.callCount.accept(statistic.getShallowCallCount());
            this.shallowCount.accept(statistic.getShallowNodeCount());
        }
    }
}

