/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.nodes;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public class IsInlinedNode
extends FloatingNode
implements IterableNodeType {
    public static final NodeClass<IsInlinedNode> TYPE = NodeClass.create(IsInlinedNode.class);

    protected IsInlinedNode() {
        super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.forKind(JavaKind.Boolean));
    }

    public static IsInlinedNode create() {
        return new IsInlinedNode();
    }

    public void inlined() {
        this.replaceWith(true);
    }

    public void notInlined() {
        this.replaceWith(false);
    }

    private void replaceWith(boolean b) {
        this.replaceAtUsagesAndDelete(this.graph().unique(ConstantNode.forBoolean(b)));
    }
}

